/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.BGPPeerIdListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBgpFailoverTestRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, StartBgpFailoverTestRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(StartBgpFailoverTestRequest.getter(StartBgpFailoverTestRequest::virtualInterfaceId)).setter(StartBgpFailoverTestRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<List<String>> BGP_PEERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bgpPeers").getter(StartBgpFailoverTestRequest.getter(StartBgpFailoverTestRequest::bgpPeers)).setter(StartBgpFailoverTestRequest.setter(Builder::bgpPeers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TEST_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testDurationInMinutes").getter(StartBgpFailoverTestRequest.getter(StartBgpFailoverTestRequest::testDurationInMinutes)).setter(StartBgpFailoverTestRequest.setter(Builder::testDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testDurationInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD, BGP_PEERS_FIELD, TEST_DURATION_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartBgpFailoverTestRequest.memberNameToFieldInitializer();
    private final String virtualInterfaceId;
    private final List<String> bgpPeers;
    private final Integer testDurationInMinutes;

    private StartBgpFailoverTestRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.bgpPeers = builder.bgpPeers;
        this.testDurationInMinutes = builder.testDurationInMinutes;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final boolean hasBgpPeers() {
        return this.bgpPeers != null && !(this.bgpPeers instanceof SdkAutoConstructList);
    }

    public final List<String> bgpPeers() {
        return this.bgpPeers;
    }

    public final Integer testDurationInMinutes() {
        return this.testDurationInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBgpPeers() ? this.bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.testDurationInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBgpFailoverTestRequest)) {
            return false;
        }
        StartBgpFailoverTestRequest other = (StartBgpFailoverTestRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && this.hasBgpPeers() == other.hasBgpPeers() && Objects.equals(this.bgpPeers(), other.bgpPeers()) && Objects.equals(this.testDurationInMinutes(), other.testDurationInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"StartBgpFailoverTestRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("BgpPeers", this.hasBgpPeers() ? this.bgpPeers() : null).add("TestDurationInMinutes", (Object)this.testDurationInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "bgpPeers": {
                return Optional.ofNullable(clazz.cast(this.bgpPeers()));
            }
            case "testDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.testDurationInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
        map.put("bgpPeers", BGP_PEERS_FIELD);
        map.put("testDurationInMinutes", TEST_DURATION_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBgpFailoverTestRequest, T> g) {
        return obj -> g.apply((StartBgpFailoverTestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private List<String> bgpPeers = DefaultSdkAutoConstructList.getInstance();
        private Integer testDurationInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBgpFailoverTestRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.bgpPeers(model.bgpPeers);
            this.testDurationInMinutes(model.testDurationInMinutes);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Collection<String> getBgpPeers() {
            if (this.bgpPeers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bgpPeers;
        }

        public final void setBgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
        }

        @Override
        public final Builder bgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(String ... bgpPeers) {
            this.bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final Integer getTestDurationInMinutes() {
            return this.testDurationInMinutes;
        }

        public final void setTestDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
        }

        @Override
        public final Builder testDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBgpFailoverTestRequest build() {
            return new StartBgpFailoverTestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBgpFailoverTestRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder bgpPeers(Collection<String> var1);

        public Builder bgpPeers(String ... var1);

        public Builder testDurationInMinutes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

