/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateMacSecKeyRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DisassociateMacSecKeyRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(DisassociateMacSecKeyRequest.getter(DisassociateMacSecKeyRequest::connectionId)).setter(DisassociateMacSecKeyRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretARN").getter(DisassociateMacSecKeyRequest.getter(DisassociateMacSecKeyRequest::secretARN)).setter(DisassociateMacSecKeyRequest.setter(Builder::secretARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectionId", CONNECTION_ID_FIELD);
            this.put("secretARN", SECRET_ARN_FIELD);
        }
    });
    private final String connectionId;
    private final String secretARN;

    private DisassociateMacSecKeyRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.secretARN = builder.secretARN;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String secretARN() {
        return this.secretARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateMacSecKeyRequest)) {
            return false;
        }
        DisassociateMacSecKeyRequest other = (DisassociateMacSecKeyRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.secretARN(), other.secretARN());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateMacSecKeyRequest").add("ConnectionId", (Object)this.connectionId()).add("SecretARN", (Object)this.secretARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "secretARN": {
                return Optional.ofNullable(clazz.cast(this.secretARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateMacSecKeyRequest, T> g) {
        return obj -> g.apply((DisassociateMacSecKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String secretARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateMacSecKeyRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.secretARN(model.secretARN);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getSecretARN() {
            return this.secretARN;
        }

        public final void setSecretARN(String secretARN) {
            this.secretARN = secretARN;
        }

        @Override
        public final Builder secretARN(String secretARN) {
            this.secretARN = secretARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateMacSecKeyRequest build() {
            return new DisassociateMacSecKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateMacSecKeyRequest> {
        public Builder connectionId(String var1);

        public Builder secretARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

