/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewTransitVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateTransitVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocateTransitVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(AllocateTransitVirtualInterfaceRequest.getter(AllocateTransitVirtualInterfaceRequest::connectionId)).setter(AllocateTransitVirtualInterfaceRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(AllocateTransitVirtualInterfaceRequest.getter(AllocateTransitVirtualInterfaceRequest::ownerAccount)).setter(AllocateTransitVirtualInterfaceRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<NewTransitVirtualInterfaceAllocation> NEW_TRANSIT_VIRTUAL_INTERFACE_ALLOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newTransitVirtualInterfaceAllocation").getter(AllocateTransitVirtualInterfaceRequest.getter(AllocateTransitVirtualInterfaceRequest::newTransitVirtualInterfaceAllocation)).setter(AllocateTransitVirtualInterfaceRequest.setter(Builder::newTransitVirtualInterfaceAllocation)).constructor(NewTransitVirtualInterfaceAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newTransitVirtualInterfaceAllocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, OWNER_ACCOUNT_FIELD, NEW_TRANSIT_VIRTUAL_INTERFACE_ALLOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectionId", CONNECTION_ID_FIELD);
            this.put("ownerAccount", OWNER_ACCOUNT_FIELD);
            this.put("newTransitVirtualInterfaceAllocation", NEW_TRANSIT_VIRTUAL_INTERFACE_ALLOCATION_FIELD);
        }
    });
    private final String connectionId;
    private final String ownerAccount;
    private final NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation;

    private AllocateTransitVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newTransitVirtualInterfaceAllocation = builder.newTransitVirtualInterfaceAllocation;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation() {
        return this.newTransitVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTransitVirtualInterfaceAllocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateTransitVirtualInterfaceRequest)) {
            return false;
        }
        AllocateTransitVirtualInterfaceRequest other = (AllocateTransitVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.newTransitVirtualInterfaceAllocation(), other.newTransitVirtualInterfaceAllocation());
    }

    public final String toString() {
        return ToString.builder((String)"AllocateTransitVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("OwnerAccount", (Object)this.ownerAccount()).add("NewTransitVirtualInterfaceAllocation", (Object)this.newTransitVirtualInterfaceAllocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "newTransitVirtualInterfaceAllocation": {
                return Optional.ofNullable(clazz.cast(this.newTransitVirtualInterfaceAllocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AllocateTransitVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AllocateTransitVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateTransitVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.newTransitVirtualInterfaceAllocation(model.newTransitVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final NewTransitVirtualInterfaceAllocation.Builder getNewTransitVirtualInterfaceAllocation() {
            return this.newTransitVirtualInterfaceAllocation != null ? this.newTransitVirtualInterfaceAllocation.toBuilder() : null;
        }

        public final void setNewTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation.BuilderImpl newTransitVirtualInterfaceAllocation) {
            this.newTransitVirtualInterfaceAllocation = newTransitVirtualInterfaceAllocation != null ? newTransitVirtualInterfaceAllocation.build() : null;
        }

        @Override
        public final Builder newTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation) {
            this.newTransitVirtualInterfaceAllocation = newTransitVirtualInterfaceAllocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateTransitVirtualInterfaceRequest build() {
            return new AllocateTransitVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateTransitVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder newTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation var1);

        default public Builder newTransitVirtualInterfaceAllocation(Consumer<NewTransitVirtualInterfaceAllocation.Builder> newTransitVirtualInterfaceAllocation) {
            return this.newTransitVirtualInterfaceAllocation((NewTransitVirtualInterfaceAllocation)((NewTransitVirtualInterfaceAllocation.Builder)NewTransitVirtualInterfaceAllocation.builder().applyMutation(newTransitVirtualInterfaceAllocation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

