/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BGPPeerState {
    VERIFYING("verifying"),
    PENDING("pending"),
    AVAILABLE("available"),
    DELETING("deleting"),
    DELETED("deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BGPPeerState> VALUE_MAP;
    private final String value;

    private BGPPeerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BGPPeerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BGPPeerState> knownValues() {
        EnumSet<BGPPeerState> knownValues = EnumSet.allOf(BGPPeerState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BGPPeerState.class, BGPPeerState::toString);
    }
}

