/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a route filter prefix that a customer can advertise through Border Gateway Protocol (BGP) over a
 * public virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteFilterPrefix implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteFilterPrefix.Builder, RouteFilterPrefix> {
    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RouteFilterPrefix::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private RouteFilterPrefix(BuilderImpl builder) {
        this.cidr = builder.cidr;
    }

    /**
     * <p>
     * The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64 or
     * shorter.
     * </p>
     * 
     * @return The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64
     *         or shorter.
     */
    public String cidr() {
        return cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteFilterPrefix)) {
            return false;
        }
        RouteFilterPrefix other = (RouteFilterPrefix) obj;
        return Objects.equals(cidr(), other.cidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RouteFilterPrefix").add("Cidr", cidr()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteFilterPrefix, T> g) {
        return obj -> g.apply((RouteFilterPrefix) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteFilterPrefix> {
        /**
         * <p>
         * The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use /64 or
         * shorter.
         * </p>
         * 
         * @param cidr
         *        The CIDR block for the advertised route. Separate multiple routes using commas. An IPv6 CIDR must use
         *        /64 or shorter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteFilterPrefix model) {
            cidr(model.cidr);
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public RouteFilterPrefix build() {
            return new RouteFilterPrefix(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
