/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a public virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewPublicVirtualInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NewPublicVirtualInterface.Builder, NewPublicVirtualInterface> {
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NewPublicVirtualInterface::virtualInterfaceName)).setter(setter(Builder::virtualInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build())
            .build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NewPublicVirtualInterface::vlan)).setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()).build();

    private static final SdkField<Integer> ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NewPublicVirtualInterface::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NewPublicVirtualInterface::authKey)).setter(setter(Builder::authKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()).build();

    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NewPublicVirtualInterface::amazonAddress)).setter(setter(Builder::amazonAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()).build();

    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NewPublicVirtualInterface::customerAddress)).setter(setter(Builder::customerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NewPublicVirtualInterface::addressFamilyAsString)).setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()).build();

    private static final SdkField<List<RouteFilterPrefix>> ROUTE_FILTER_PREFIXES_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .getter(getter(NewPublicVirtualInterface::routeFilterPrefixes))
            .setter(setter(Builder::routeFilterPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeFilterPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(NewPublicVirtualInterface::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_NAME_FIELD,
            VLAN_FIELD, ASN_FIELD, AUTH_KEY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, ADDRESS_FAMILY_FIELD,
            ROUTE_FILTER_PREFIXES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualInterfaceName;

    private final Integer vlan;

    private final Integer asn;

    private final String authKey;

    private final String amazonAddress;

    private final String customerAddress;

    private final String addressFamily;

    private final List<RouteFilterPrefix> routeFilterPrefixes;

    private final List<Tag> tags;

    private NewPublicVirtualInterface(BuilderImpl builder) {
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The
     * following are valid characters: a-z, 0-9 and a hyphen (-).
     * </p>
     * 
     * @return The name of the virtual interface assigned by the customer network. The name has a maximum of 100
     *         characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
     */
    public String virtualInterfaceName() {
        return virtualInterfaceName;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * </p>
     * <p>
     * The valid values are 1-2147483647.
     * </p>
     * 
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
     *         <p>
     *         The valid values are 1-2147483647.
     */
    public Integer asn() {
        return asn;
    }

    /**
     * <p>
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun
     * lenth of 80 characters.
     * </p>
     * 
     * @return The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
     *         maximun lenth of 80 characters.
     */
    public String authKey() {
        return authKey;
    }

    /**
     * <p>
     * The IP address assigned to the Amazon interface.
     * </p>
     * 
     * @return The IP address assigned to the Amazon interface.
     */
    public String amazonAddress() {
        return amazonAddress;
    }

    /**
     * <p>
     * The IP address assigned to the customer interface.
     * </p>
     * 
     * @return The IP address assigned to the customer interface.
     */
    public String customerAddress() {
        return customerAddress;
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(addressFamily);
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public String addressFamilyAsString() {
        return addressFamily;
    }

    /**
     * Returns true if the RouteFilterPrefixes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRouteFilterPrefixes() {
        return routeFilterPrefixes != null && !(routeFilterPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRouteFilterPrefixes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
     */
    public List<RouteFilterPrefix> routeFilterPrefixes() {
        return routeFilterPrefixes;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the public virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the public virtual interface.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(authKey());
        hashCode = 31 * hashCode + Objects.hashCode(amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routeFilterPrefixes());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewPublicVirtualInterface)) {
            return false;
        }
        NewPublicVirtualInterface other = (NewPublicVirtualInterface) obj;
        return Objects.equals(virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(asn(), other.asn()) && Objects.equals(authKey(), other.authKey())
                && Objects.equals(amazonAddress(), other.amazonAddress())
                && Objects.equals(customerAddress(), other.customerAddress())
                && Objects.equals(addressFamilyAsString(), other.addressFamilyAsString())
                && Objects.equals(routeFilterPrefixes(), other.routeFilterPrefixes()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NewPublicVirtualInterface").add("VirtualInterfaceName", virtualInterfaceName())
                .add("Vlan", vlan()).add("Asn", asn()).add("AuthKey", authKey()).add("AmazonAddress", amazonAddress())
                .add("CustomerAddress", customerAddress()).add("AddressFamily", addressFamilyAsString())
                .add("RouteFilterPrefixes", routeFilterPrefixes()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceName":
            return Optional.ofNullable(clazz.cast(virtualInterfaceName()));
        case "vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "authKey":
            return Optional.ofNullable(clazz.cast(authKey()));
        case "amazonAddress":
            return Optional.ofNullable(clazz.cast(amazonAddress()));
        case "customerAddress":
            return Optional.ofNullable(clazz.cast(customerAddress()));
        case "addressFamily":
            return Optional.ofNullable(clazz.cast(addressFamilyAsString()));
        case "routeFilterPrefixes":
            return Optional.ofNullable(clazz.cast(routeFilterPrefixes()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewPublicVirtualInterface, T> g) {
        return obj -> g.apply((NewPublicVirtualInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewPublicVirtualInterface> {
        /**
         * <p>
         * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters.
         * The following are valid characters: a-z, 0-9 and a hyphen (-).
         * </p>
         * 
         * @param virtualInterfaceName
         *        The name of the virtual interface assigned by the customer network. The name has a maximum of 100
         *        characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceName(String virtualInterfaceName);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * </p>
         * <p>
         * The valid values are 1-2147483647.
         * </p>
         * 
         * @param asn
         *        The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
         *        <p>
         *        The valid values are 1-2147483647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Integer asn);

        /**
         * <p>
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
         * maximun lenth of 80 characters.
         * </p>
         * 
         * @param authKey
         *        The authentication key for BGP configuration. This string has a minimum length of 6 characters and and
         *        a maximun lenth of 80 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authKey(String authKey);

        /**
         * <p>
         * The IP address assigned to the Amazon interface.
         * </p>
         * 
         * @param amazonAddress
         *        The IP address assigned to the Amazon interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonAddress(String amazonAddress);

        /**
         * <p>
         * The IP address assigned to the customer interface.
         * </p>
         * 
         * @param customerAddress
         *        The IP address assigned to the customer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAddress(String customerAddress);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(AddressFamily addressFamily);

        /**
         * <p>
         * The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
         * </p>
         * 
         * @param routeFilterPrefixes
         *        The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes);

        /**
         * <p>
         * The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
         * </p>
         * 
         * @param routeFilterPrefixes
         *        The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeFilterPrefixes(RouteFilterPrefix... routeFilterPrefixes);

        /**
         * <p>
         * The routes to be advertised to the AWS network in this Region. Applies to public virtual interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #routeFilterPrefixes(List<RouteFilterPrefix>)}.
         * 
         * @param routeFilterPrefixes
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeFilterPrefixes(List<RouteFilterPrefix>)
         */
        Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder>... routeFilterPrefixes);

        /**
         * <p>
         * The tags associated with the public virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the public virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the public virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the public virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the public virtual interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String virtualInterfaceName;

        private Integer vlan;

        private Integer asn;

        private String authKey;

        private String amazonAddress;

        private String customerAddress;

        private String addressFamily;

        private List<RouteFilterPrefix> routeFilterPrefixes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NewPublicVirtualInterface model) {
            virtualInterfaceName(model.virtualInterfaceName);
            vlan(model.vlan);
            asn(model.asn);
            authKey(model.authKey);
            amazonAddress(model.amazonAddress);
            customerAddress(model.customerAddress);
            addressFamily(model.addressFamily);
            routeFilterPrefixes(model.routeFilterPrefixes);
            tags(model.tags);
        }

        public final String getVirtualInterfaceName() {
            return virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        public final Integer getVlan() {
            return vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final Integer getAsn() {
            return asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAmazonAddress() {
            return amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final Collection<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            return routeFilterPrefixes != null ? routeFilterPrefixes.stream().map(RouteFilterPrefix::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix... routeFilterPrefixes) {
            routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder>... routeFilterPrefixes) {
            routeFilterPrefixes(Stream.of(routeFilterPrefixes).map(c -> RouteFilterPrefix.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public NewPublicVirtualInterface build() {
            return new NewPublicVirtualInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
