/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVirtualInterfacesResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeVirtualInterfacesResponse.Builder, DescribeVirtualInterfacesResponse> {
    private static final SdkField<List<VirtualInterface>> VIRTUAL_INTERFACES_FIELD = SdkField
            .<List<VirtualInterface>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVirtualInterfacesResponse::virtualInterfaces))
            .setter(setter(Builder::virtualInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACES_FIELD));

    private final List<VirtualInterface> virtualInterfaces;

    private DescribeVirtualInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaces = builder.virtualInterfaces;
    }

    /**
     * Returns true if the VirtualInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVirtualInterfaces() {
        return virtualInterfaces != null && !(virtualInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtual interfaces
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVirtualInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The virtual interfaces
     */
    public List<VirtualInterface> virtualInterfaces() {
        return virtualInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaces());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualInterfacesResponse)) {
            return false;
        }
        DescribeVirtualInterfacesResponse other = (DescribeVirtualInterfacesResponse) obj;
        return Objects.equals(virtualInterfaces(), other.virtualInterfaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVirtualInterfacesResponse").add("VirtualInterfaces", virtualInterfaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaces":
            return Optional.ofNullable(clazz.cast(virtualInterfaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualInterfacesResponse, T> g) {
        return obj -> g.apply((DescribeVirtualInterfacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVirtualInterfacesResponse> {
        /**
         * <p>
         * The virtual interfaces
         * </p>
         * 
         * @param virtualInterfaces
         *        The virtual interfaces
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaces(Collection<VirtualInterface> virtualInterfaces);

        /**
         * <p>
         * The virtual interfaces
         * </p>
         * 
         * @param virtualInterfaces
         *        The virtual interfaces
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaces(VirtualInterface... virtualInterfaces);

        /**
         * <p>
         * The virtual interfaces
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualInterface>.Builder} avoiding the
         * need to create one manually via {@link List<VirtualInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualInterface>.Builder#build()} is called immediately and
         * its result is passed to {@link #virtualInterfaces(List<VirtualInterface>)}.
         * 
         * @param virtualInterfaces
         *        a consumer that will call methods on {@link List<VirtualInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualInterfaces(List<VirtualInterface>)
         */
        Builder virtualInterfaces(Consumer<VirtualInterface.Builder>... virtualInterfaces);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<VirtualInterface> virtualInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualInterfacesResponse model) {
            super(model);
            virtualInterfaces(model.virtualInterfaces);
        }

        public final Collection<VirtualInterface.Builder> getVirtualInterfaces() {
            return virtualInterfaces != null ? virtualInterfaces.stream().map(VirtualInterface::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualInterfaces(Collection<VirtualInterface> virtualInterfaces) {
            this.virtualInterfaces = VirtualInterfaceListCopier.copy(virtualInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaces(VirtualInterface... virtualInterfaces) {
            virtualInterfaces(Arrays.asList(virtualInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaces(Consumer<VirtualInterface.Builder>... virtualInterfaces) {
            virtualInterfaces(Stream.of(virtualInterfaces).map(c -> VirtualInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualInterfaces(Collection<VirtualInterface.BuilderImpl> virtualInterfaces) {
            this.virtualInterfaces = VirtualInterfaceListCopier.copyFromBuilder(virtualInterfaces);
        }

        @Override
        public DescribeVirtualInterfacesResponse build() {
            return new DescribeVirtualInterfacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
