/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocatePrivateVirtualInterfaceRequest extends DirectConnectRequest implements
        ToCopyableBuilder<AllocatePrivateVirtualInterfaceRequest.Builder, AllocatePrivateVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AllocatePrivateVirtualInterfaceRequest::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AllocatePrivateVirtualInterfaceRequest::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<NewPrivateVirtualInterfaceAllocation> NEW_PRIVATE_VIRTUAL_INTERFACE_ALLOCATION_FIELD = SdkField
            .<NewPrivateVirtualInterfaceAllocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(AllocatePrivateVirtualInterfaceRequest::newPrivateVirtualInterfaceAllocation))
            .setter(setter(Builder::newPrivateVirtualInterfaceAllocation))
            .constructor(NewPrivateVirtualInterfaceAllocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("newPrivateVirtualInterfaceAllocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            OWNER_ACCOUNT_FIELD, NEW_PRIVATE_VIRTUAL_INTERFACE_ALLOCATION_FIELD));

    private final String connectionId;

    private final String ownerAccount;

    private final NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation;

    private AllocatePrivateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newPrivateVirtualInterfaceAllocation = builder.newPrivateVirtualInterfaceAllocation;
    }

    /**
     * <p>
     * The ID of the connection on which the private virtual interface is provisioned.
     * </p>
     * 
     * @return The ID of the connection on which the private virtual interface is provisioned.
     */
    public String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the virtual private interface.
     * </p>
     * 
     * @return The ID of the AWS account that owns the virtual private interface.
     */
    public String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * Information about the private virtual interface.
     * </p>
     * 
     * @return Information about the private virtual interface.
     */
    public NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation() {
        return newPrivateVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(newPrivateVirtualInterfaceAllocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePrivateVirtualInterfaceRequest)) {
            return false;
        }
        AllocatePrivateVirtualInterfaceRequest other = (AllocatePrivateVirtualInterfaceRequest) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(newPrivateVirtualInterfaceAllocation(), other.newPrivateVirtualInterfaceAllocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AllocatePrivateVirtualInterfaceRequest").add("ConnectionId", connectionId())
                .add("OwnerAccount", ownerAccount())
                .add("NewPrivateVirtualInterfaceAllocation", newPrivateVirtualInterfaceAllocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "newPrivateVirtualInterfaceAllocation":
            return Optional.ofNullable(clazz.cast(newPrivateVirtualInterfaceAllocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocatePrivateVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AllocatePrivateVirtualInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AllocatePrivateVirtualInterfaceRequest> {
        /**
         * <p>
         * The ID of the connection on which the private virtual interface is provisioned.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection on which the private virtual interface is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The ID of the AWS account that owns the virtual private interface.
         * </p>
         * 
         * @param ownerAccount
         *        The ID of the AWS account that owns the virtual private interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * Information about the private virtual interface.
         * </p>
         * 
         * @param newPrivateVirtualInterfaceAllocation
         *        Information about the private virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation);

        /**
         * <p>
         * Information about the private virtual interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NewPrivateVirtualInterfaceAllocation.Builder}
         * avoiding the need to create one manually via {@link NewPrivateVirtualInterfaceAllocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewPrivateVirtualInterfaceAllocation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation)}.
         * 
         * @param newPrivateVirtualInterfaceAllocation
         *        a consumer that will call methods on {@link NewPrivateVirtualInterfaceAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation)
         */
        default Builder newPrivateVirtualInterfaceAllocation(
                Consumer<NewPrivateVirtualInterfaceAllocation.Builder> newPrivateVirtualInterfaceAllocation) {
            return newPrivateVirtualInterfaceAllocation(NewPrivateVirtualInterfaceAllocation.builder()
                    .applyMutation(newPrivateVirtualInterfaceAllocation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private String ownerAccount;

        private NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePrivateVirtualInterfaceRequest model) {
            super(model);
            connectionId(model.connectionId);
            ownerAccount(model.ownerAccount);
            newPrivateVirtualInterfaceAllocation(model.newPrivateVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final NewPrivateVirtualInterfaceAllocation.Builder getNewPrivateVirtualInterfaceAllocation() {
            return newPrivateVirtualInterfaceAllocation != null ? newPrivateVirtualInterfaceAllocation.toBuilder() : null;
        }

        @Override
        public final Builder newPrivateVirtualInterfaceAllocation(
                NewPrivateVirtualInterfaceAllocation newPrivateVirtualInterfaceAllocation) {
            this.newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation;
            return this;
        }

        public final void setNewPrivateVirtualInterfaceAllocation(
                NewPrivateVirtualInterfaceAllocation.BuilderImpl newPrivateVirtualInterfaceAllocation) {
            this.newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation != null ? newPrivateVirtualInterfaceAllocation
                    .build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocatePrivateVirtualInterfaceRequest build() {
            return new AllocatePrivateVirtualInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
