/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Loa;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LoaMarshaller {
    private static final MarshallingInfo<ByteBuffer> LOACONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContent").isBinary(false).build();
    private static final MarshallingInfo<String> LOACONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContentType").isBinary(false).build();
    private static final LoaMarshaller INSTANCE = new LoaMarshaller();

    private LoaMarshaller() {
    }

    public static LoaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Loa loa, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)loa, (String)"loa");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)loa.loaContent(), LOACONTENT_BINDING);
            protocolMarshaller.marshall((Object)loa.loaContentTypeString(), LOACONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

