/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConnectionsRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeConnectionsRequest> {
    private final String connectionId;

    private DescribeConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionsRequest)) {
            return false;
        }
        DescribeConnectionsRequest other = (DescribeConnectionsRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConnectionsRequest").add("ConnectionId", (Object)this.connectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionsRequest model) {
            this.connectionId(model.connectionId);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectionsRequest build() {
            return new DescribeConnectionsRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DescribeConnectionsRequest> {
        public Builder connectionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

