/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.ResourceArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeTagsRequest> {
    private final List<String> resourceArns;

    private DescribeTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArns = builder.resourceArns;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest)((Object)obj);
        return Objects.equals(this.resourceArns(), other.resourceArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsRequest").add("ResourceArns", this.resourceArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArns": {
                return Optional.of(clazz.cast(this.resourceArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private List<String> resourceArns;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            this.resourceArns(model.resourceArns);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DescribeTagsRequest> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

