/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConnectionsOnInterconnectResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeConnectionsOnInterconnectResponse> {
    private final List<Connection> connections;

    private DescribeConnectionsOnInterconnectResponse(BuilderImpl builder) {
        super(builder);
        this.connections = builder.connections;
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionsOnInterconnectResponse)) {
            return false;
        }
        DescribeConnectionsOnInterconnectResponse other = (DescribeConnectionsOnInterconnectResponse)((Object)obj);
        return Objects.equals(this.connections(), other.connections());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConnectionsOnInterconnectResponse").add("Connections", this.connections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connections": {
                return Optional.of(clazz.cast(this.connections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<Connection> connections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionsOnInterconnectResponse model) {
            this.connections(model.connections);
        }

        public final Collection<Connection.Builder> getConnections() {
            return this.connections != null ? (Collection)this.connections.stream().map(Connection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public DescribeConnectionsOnInterconnectResponse build() {
            return new DescribeConnectionsOnInterconnectResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeConnectionsOnInterconnectResponse> {
        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);
    }
}

