/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.directconnect.DirectConnectAsyncClient;
import software.amazon.awssdk.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateConnectionOnInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateBGPPeerRequest;
import software.amazon.awssdk.services.directconnect.model.CreateBGPPeerResponse;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.CreateLagRequest;
import software.amazon.awssdk.services.directconnect.model.CreateLagResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteBGPPeerRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteBGPPeerResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteLagRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteLagResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsOnInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsOnInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse;
import software.amazon.awssdk.services.directconnect.model.DirectConnectClientException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectServerException;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse;
import software.amazon.awssdk.services.directconnect.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.directconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.directconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateLagRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateLagResponse;
import software.amazon.awssdk.services.directconnect.transform.AllocateConnectionOnInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateConnectionOnInterconnectResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateHostedConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePrivateVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePublicVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateConnectionWithLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateConnectionWithLagResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateHostedConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPrivateVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPublicVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateBGPPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateBGPPeerResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateInterconnectResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateLagResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePrivateVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePublicVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteBGPPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteBGPPeerResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteInterconnectResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteLagResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteVirtualInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionLoaRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionLoaResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsOnInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsOnInterconnectResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAttachmentsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeHostedConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeHostedConnectionsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectLoaRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectLoaResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLagsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLoaRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLoaResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLocationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLocationsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualInterfacesResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateConnectionFromLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateConnectionFromLagResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateLagResponseUnmarshaller;

@SdkInternalApi
final class DefaultDirectConnectAsyncClient
implements DirectConnectAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultDirectConnectAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "directconnect";
    }

    @Override
    public CompletableFuture<AllocateConnectionOnInterconnectResponse> allocateConnectionOnInterconnect(AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AllocateConnectionOnInterconnectResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AllocateConnectionOnInterconnectRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)allocateConnectionOnInterconnectRequest));
    }

    @Override
    public CompletableFuture<AllocateHostedConnectionResponse> allocateHostedConnection(AllocateHostedConnectionRequest allocateHostedConnectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AllocateHostedConnectionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AllocateHostedConnectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)allocateHostedConnectionRequest));
    }

    @Override
    public CompletableFuture<AllocatePrivateVirtualInterfaceResponse> allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AllocatePrivateVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AllocatePrivateVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)allocatePrivateVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<AllocatePublicVirtualInterfaceResponse> allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AllocatePublicVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AllocatePublicVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)allocatePublicVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<AssociateConnectionWithLagResponse> associateConnectionWithLag(AssociateConnectionWithLagRequest associateConnectionWithLagRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateConnectionWithLagResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssociateConnectionWithLagRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateConnectionWithLagRequest));
    }

    @Override
    public CompletableFuture<AssociateHostedConnectionResponse> associateHostedConnection(AssociateHostedConnectionRequest associateHostedConnectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateHostedConnectionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssociateHostedConnectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateHostedConnectionRequest));
    }

    @Override
    public CompletableFuture<AssociateVirtualInterfaceResponse> associateVirtualInterface(AssociateVirtualInterfaceRequest associateVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssociateVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<ConfirmConnectionResponse> confirmConnection(ConfirmConnectionRequest confirmConnectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ConfirmConnectionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ConfirmConnectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmConnectionRequest));
    }

    @Override
    public CompletableFuture<ConfirmPrivateVirtualInterfaceResponse> confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ConfirmPrivateVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ConfirmPrivateVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmPrivateVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<ConfirmPublicVirtualInterfaceResponse> confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ConfirmPublicVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ConfirmPublicVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmPublicVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<CreateBGPPeerResponse> createBGPPeer(CreateBGPPeerRequest createBGPPeerRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBGPPeerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateBGPPeerRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBGPPeerRequest));
    }

    @Override
    public CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConnectionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateConnectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConnectionRequest));
    }

    @Override
    public CompletableFuture<CreateDirectConnectGatewayResponse> createDirectConnectGateway(CreateDirectConnectGatewayRequest createDirectConnectGatewayRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDirectConnectGatewayResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDirectConnectGatewayRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDirectConnectGatewayRequest));
    }

    @Override
    public CompletableFuture<CreateDirectConnectGatewayAssociationResponse> createDirectConnectGatewayAssociation(CreateDirectConnectGatewayAssociationRequest createDirectConnectGatewayAssociationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDirectConnectGatewayAssociationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDirectConnectGatewayAssociationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDirectConnectGatewayAssociationRequest));
    }

    @Override
    public CompletableFuture<CreateInterconnectResponse> createInterconnect(CreateInterconnectRequest createInterconnectRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInterconnectResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateInterconnectRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createInterconnectRequest));
    }

    @Override
    public CompletableFuture<CreateLagResponse> createLag(CreateLagRequest createLagRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLagResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateLagRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLagRequest));
    }

    @Override
    public CompletableFuture<CreatePrivateVirtualInterfaceResponse> createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePrivateVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreatePrivateVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPrivateVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<CreatePublicVirtualInterfaceResponse> createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePublicVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreatePublicVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPublicVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<DeleteBGPPeerResponse> deleteBGPPeer(DeleteBGPPeerRequest deleteBGPPeerRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBGPPeerResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteBGPPeerRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBGPPeerRequest));
    }

    @Override
    public CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConnectionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectionRequest));
    }

    @Override
    public CompletableFuture<DeleteDirectConnectGatewayResponse> deleteDirectConnectGateway(DeleteDirectConnectGatewayRequest deleteDirectConnectGatewayRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDirectConnectGatewayResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDirectConnectGatewayRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDirectConnectGatewayRequest));
    }

    @Override
    public CompletableFuture<DeleteDirectConnectGatewayAssociationResponse> deleteDirectConnectGatewayAssociation(DeleteDirectConnectGatewayAssociationRequest deleteDirectConnectGatewayAssociationRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDirectConnectGatewayAssociationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDirectConnectGatewayAssociationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDirectConnectGatewayAssociationRequest));
    }

    @Override
    public CompletableFuture<DeleteInterconnectResponse> deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInterconnectResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteInterconnectRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInterconnectRequest));
    }

    @Override
    public CompletableFuture<DeleteLagResponse> deleteLag(DeleteLagRequest deleteLagRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLagResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteLagRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLagRequest));
    }

    @Override
    public CompletableFuture<DeleteVirtualInterfaceResponse> deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVirtualInterfaceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteVirtualInterfaceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVirtualInterfaceRequest));
    }

    @Override
    public CompletableFuture<DescribeConnectionLoaResponse> describeConnectionLoa(DescribeConnectionLoaRequest describeConnectionLoaRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectionLoaResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeConnectionLoaRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectionLoaRequest));
    }

    @Override
    public CompletableFuture<DescribeConnectionsResponse> describeConnections(DescribeConnectionsRequest describeConnectionsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectionsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeConnectionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectionsRequest));
    }

    @Override
    public CompletableFuture<DescribeConnectionsOnInterconnectResponse> describeConnectionsOnInterconnect(DescribeConnectionsOnInterconnectRequest describeConnectionsOnInterconnectRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConnectionsOnInterconnectResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeConnectionsOnInterconnectRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectionsOnInterconnectRequest));
    }

    @Override
    public CompletableFuture<DescribeDirectConnectGatewayAssociationsResponse> describeDirectConnectGatewayAssociations(DescribeDirectConnectGatewayAssociationsRequest describeDirectConnectGatewayAssociationsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDirectConnectGatewayAssociationsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeDirectConnectGatewayAssociationsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDirectConnectGatewayAssociationsRequest));
    }

    @Override
    public CompletableFuture<DescribeDirectConnectGatewayAttachmentsResponse> describeDirectConnectGatewayAttachments(DescribeDirectConnectGatewayAttachmentsRequest describeDirectConnectGatewayAttachmentsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDirectConnectGatewayAttachmentsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeDirectConnectGatewayAttachmentsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDirectConnectGatewayAttachmentsRequest));
    }

    @Override
    public CompletableFuture<DescribeDirectConnectGatewaysResponse> describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest describeDirectConnectGatewaysRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDirectConnectGatewaysResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeDirectConnectGatewaysRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDirectConnectGatewaysRequest));
    }

    @Override
    public CompletableFuture<DescribeHostedConnectionsResponse> describeHostedConnections(DescribeHostedConnectionsRequest describeHostedConnectionsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHostedConnectionsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeHostedConnectionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHostedConnectionsRequest));
    }

    @Override
    public CompletableFuture<DescribeInterconnectLoaResponse> describeInterconnectLoa(DescribeInterconnectLoaRequest describeInterconnectLoaRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInterconnectLoaResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeInterconnectLoaRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInterconnectLoaRequest));
    }

    @Override
    public CompletableFuture<DescribeInterconnectsResponse> describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInterconnectsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeInterconnectsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInterconnectsRequest));
    }

    @Override
    public CompletableFuture<DescribeLagsResponse> describeLags(DescribeLagsRequest describeLagsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLagsRequest));
    }

    @Override
    public CompletableFuture<DescribeLoaResponse> describeLoa(DescribeLoaRequest describeLoaRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLoaResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLoaRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoaRequest));
    }

    @Override
    public CompletableFuture<DescribeLocationsResponse> describeLocations(DescribeLocationsRequest describeLocationsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLocationsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLocationsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLocationsRequest));
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest));
    }

    @Override
    public CompletableFuture<DescribeVirtualGatewaysResponse> describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVirtualGatewaysResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeVirtualGatewaysRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualGatewaysRequest));
    }

    @Override
    public CompletableFuture<DescribeVirtualInterfacesResponse> describeVirtualInterfaces(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVirtualInterfacesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeVirtualInterfacesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVirtualInterfacesRequest));
    }

    @Override
    public CompletableFuture<DisassociateConnectionFromLagResponse> disassociateConnectionFromLag(DisassociateConnectionFromLagRequest disassociateConnectionFromLagRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateConnectionFromLagResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DisassociateConnectionFromLagRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateConnectionFromLagRequest));
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest));
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest));
    }

    @Override
    public CompletableFuture<UpdateLagResponse> updateLag(UpdateLagRequest updateLagRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLagResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateLagRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLagRequest));
    }

    public void close() {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DirectConnectException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateTagKeysException").withModeledClass(DuplicateTagKeysException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withModeledClass(TooManyTagsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DirectConnectServerException").withModeledClass(DirectConnectServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DirectConnectClientException").withModeledClass(DirectConnectClientException.class)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

