/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.directconnect.model.Lag;
import software.amazon.awssdk.services.directconnect.transform.ConnectionUnmarshaller;

public class LagUnmarshaller
implements Unmarshaller<Lag, JsonUnmarshallerContext> {
    private static final LagUnmarshaller INSTANCE = new LagUnmarshaller();

    public Lag unmarshall(JsonUnmarshallerContext context) throws Exception {
        Lag.Builder lagBuilder = Lag.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("connectionsBandwidth", targetDepth)) {
                    context.nextToken();
                    lagBuilder.connectionsBandwidth((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("numberOfConnections", targetDepth)) {
                    context.nextToken();
                    lagBuilder.numberOfConnections((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("lagId", targetDepth)) {
                    context.nextToken();
                    lagBuilder.lagId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ownerAccount", targetDepth)) {
                    context.nextToken();
                    lagBuilder.ownerAccount((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("lagName", targetDepth)) {
                    context.nextToken();
                    lagBuilder.lagName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("lagState", targetDepth)) {
                    context.nextToken();
                    lagBuilder.lagState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    lagBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("region", targetDepth)) {
                    context.nextToken();
                    lagBuilder.region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("minimumLinks", targetDepth)) {
                    context.nextToken();
                    lagBuilder.minimumLinks((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsDevice", targetDepth)) {
                    context.nextToken();
                    lagBuilder.awsDevice((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("connections", targetDepth)) {
                    context.nextToken();
                    lagBuilder.connections(new ListUnmarshaller((Unmarshaller)ConnectionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("allowsHostedConnections", targetDepth)) {
                    context.nextToken();
                    lagBuilder.allowsHostedConnections((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Lag)lagBuilder.build();
    }

    public static LagUnmarshaller getInstance() {
        return INSTANCE;
    }
}

