/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInterconnectsRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeInterconnectsRequest> {
    private final String interconnectId;

    private DescribeInterconnectsRequest(BuilderImpl builder) {
        super(builder);
        this.interconnectId = builder.interconnectId;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectsRequest)) {
            return false;
        }
        DescribeInterconnectsRequest other = (DescribeInterconnectsRequest)((Object)obj);
        return Objects.equals(this.interconnectId(), other.interconnectId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.interconnectId() != null) {
            sb.append("InterconnectId: ").append(this.interconnectId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.of(clazz.cast(this.interconnectId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String interconnectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectsRequest model) {
            this.interconnectId(model.interconnectId);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInterconnectsRequest build() {
            return new DescribeInterconnectsRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DescribeInterconnectsRequest> {
        public Builder interconnectId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

