/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGateway;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDirectConnectGatewaysResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewaysResponse> {
    private final List<DirectConnectGateway> directConnectGateways;
    private final String nextToken;

    private DescribeDirectConnectGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGateways = builder.directConnectGateways;
        this.nextToken = builder.nextToken;
    }

    public List<DirectConnectGateway> directConnectGateways() {
        return this.directConnectGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGateways());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewaysResponse)) {
            return false;
        }
        DescribeDirectConnectGatewaysResponse other = (DescribeDirectConnectGatewaysResponse)((Object)obj);
        return Objects.equals(this.directConnectGateways(), other.directConnectGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directConnectGateways() != null) {
            sb.append("DirectConnectGateways: ").append(this.directConnectGateways()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGateways": {
                return Optional.of(clazz.cast(this.directConnectGateways()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<DirectConnectGateway> directConnectGateways;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewaysResponse model) {
            this.directConnectGateways(model.directConnectGateways);
            this.nextToken(model.nextToken);
        }

        public final Collection<DirectConnectGateway.Builder> getDirectConnectGateways() {
            return this.directConnectGateways != null ? (Collection)this.directConnectGateways.stream().map(DirectConnectGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directConnectGateways(Collection<DirectConnectGateway> directConnectGateways) {
            this.directConnectGateways = DirectConnectGatewayListCopier.copy(directConnectGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGateways(DirectConnectGateway ... directConnectGateways) {
            this.directConnectGateways(Arrays.asList(directConnectGateways));
            return this;
        }

        public final void setDirectConnectGateways(Collection<DirectConnectGateway.BuilderImpl> directConnectGateways) {
            this.directConnectGateways = DirectConnectGatewayListCopier.copyFromBuilder(directConnectGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectConnectGatewaysResponse build() {
            return new DescribeDirectConnectGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DescribeDirectConnectGatewaysResponse> {
        public Builder directConnectGateways(Collection<DirectConnectGateway> var1);

        public Builder directConnectGateways(DirectConnectGateway ... var1);

        public Builder nextToken(String var1);
    }
}

