/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteDirectConnectGatewayAssociationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteDirectConnectGatewayAssociationRequest> {
    private final String directConnectGatewayId;
    private final String virtualGatewayId;

    private DeleteDirectConnectGatewayAssociationRequest(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.virtualGatewayId = builder.virtualGatewayId;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String virtualGatewayId() {
        return this.virtualGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDirectConnectGatewayAssociationRequest)) {
            return false;
        }
        DeleteDirectConnectGatewayAssociationRequest other = (DeleteDirectConnectGatewayAssociationRequest)((Object)obj);
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.virtualGatewayId(), other.virtualGatewayId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directConnectGatewayId() != null) {
            sb.append("DirectConnectGatewayId: ").append(this.directConnectGatewayId()).append(",");
        }
        if (this.virtualGatewayId() != null) {
            sb.append("VirtualGatewayId: ").append(this.virtualGatewayId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.of(clazz.cast(this.directConnectGatewayId()));
            }
            case "virtualGatewayId": {
                return Optional.of(clazz.cast(this.virtualGatewayId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String virtualGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDirectConnectGatewayAssociationRequest model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.virtualGatewayId(model.virtualGatewayId);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getVirtualGatewayId() {
            return this.virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        public DeleteDirectConnectGatewayAssociationRequest build() {
            return new DeleteDirectConnectGatewayAssociationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteDirectConnectGatewayAssociationRequest> {
        public Builder directConnectGatewayId(String var1);

        public Builder virtualGatewayId(String var1);
    }
}

