/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateVirtualInterfaceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateVirtualInterfaceRequest> {
    private final String virtualInterfaceId;
    private final String connectionId;

    private AssociateVirtualInterfaceRequest(BuilderImpl builder) {
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.connectionId = builder.connectionId;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVirtualInterfaceRequest)) {
            return false;
        }
        AssociateVirtualInterfaceRequest other = (AssociateVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.connectionId(), other.connectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.virtualInterfaceId() != null) {
            sb.append("VirtualInterfaceId: ").append(this.virtualInterfaceId()).append(",");
        }
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private String connectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVirtualInterfaceRequest model) {
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.connectionId(model.connectionId);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public AssociateVirtualInterfaceRequest build() {
            return new AssociateVirtualInterfaceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateVirtualInterfaceRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder connectionId(String var1);
    }
}

