/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.Lag;
import software.amazon.awssdk.services.directconnect.model.LagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLagsResponse> {
    private final List<Lag> lags;

    private DescribeLagsResponse(BuilderImpl builder) {
        this.lags = builder.lags;
    }

    public List<Lag> lags() {
        return this.lags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lags() == null ? 0 : this.lags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLagsResponse)) {
            return false;
        }
        DescribeLagsResponse other = (DescribeLagsResponse)((Object)obj);
        if (other.lags() == null ^ this.lags() == null) {
            return false;
        }
        return other.lags() == null || other.lags().equals(this.lags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lags() != null) {
            sb.append("Lags: ").append(this.lags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lags": {
                return Optional.of(clazz.cast(this.lags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Lag> lags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLagsResponse model) {
            this.lags(model.lags);
        }

        public final Collection<Lag.Builder> getLags() {
            return this.lags != null ? (Collection)this.lags.stream().map(Lag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lags(Collection<Lag> lags) {
            this.lags = LagListCopier.copy(lags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lags(Lag ... lags) {
            this.lags(Arrays.asList(lags));
            return this;
        }

        public final void setLags(Collection<Lag.BuilderImpl> lags) {
            this.lags = LagListCopier.copyFromBuilder(lags);
        }

        public DescribeLagsResponse build() {
            return new DescribeLagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLagsResponse> {
        public Builder lags(Collection<Lag> var1);

        public Builder lags(Lag ... var1);
    }
}

