/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostedConnectionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHostedConnectionsResponse> {
    private final List<Connection> connections;

    private DescribeHostedConnectionsResponse(BuilderImpl builder) {
        this.connections = builder.connections;
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connections() == null ? 0 : this.connections().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostedConnectionsResponse)) {
            return false;
        }
        DescribeHostedConnectionsResponse other = (DescribeHostedConnectionsResponse)((Object)obj);
        if (other.connections() == null ^ this.connections() == null) {
            return false;
        }
        return other.connections() == null || other.connections().equals(this.connections());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.connections() != null) {
            sb.append("Connections: ").append(this.connections()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connections": {
                return Optional.of(clazz.cast(this.connections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Connection> connections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostedConnectionsResponse model) {
            this.connections(model.connections);
        }

        public final Collection<Connection.Builder> getConnections() {
            return this.connections != null ? (Collection)this.connections.stream().map(Connection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionListCopier.copyFromBuilder(connections);
        }

        public DescribeHostedConnectionsResponse build() {
            return new DescribeHostedConnectionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostedConnectionsResponse> {
        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);
    }
}

