/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.BGPPeer;

@SdkInternalApi
public class BGPPeerMarshaller {
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").build();
    private static final MarshallingInfo<String> BGPPEERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpPeerState").build();
    private static final MarshallingInfo<String> BGPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpStatus").build();
    private static final BGPPeerMarshaller instance = new BGPPeerMarshaller();

    public static BGPPeerMarshaller getInstance() {
        return instance;
    }

    public void marshall(BGPPeer bgpPeer, ProtocolMarshaller protocolMarshaller) {
        if (bgpPeer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bgpPeer.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.addressFamily(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.customerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.bgpPeerState(), BGPPEERSTATE_BINDING);
            protocolMarshaller.marshall((Object)bgpPeer.bgpStatus(), BGPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

