/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.transform.NewBGPPeerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NewBGPPeer
implements StructuredPojo,
ToCopyableBuilder<Builder, NewBGPPeer> {
    private final Integer asn;
    private final String authKey;
    private final String addressFamily;
    private final String amazonAddress;
    private final String customerAddress;

    private NewBGPPeer(BuilderImpl builder) {
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public String addressFamily() {
        return this.addressFamily;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.asn() == null ? 0 : this.asn().hashCode());
        hashCode = 31 * hashCode + (this.authKey() == null ? 0 : this.authKey().hashCode());
        hashCode = 31 * hashCode + (this.addressFamily() == null ? 0 : this.addressFamily().hashCode());
        hashCode = 31 * hashCode + (this.amazonAddress() == null ? 0 : this.amazonAddress().hashCode());
        hashCode = 31 * hashCode + (this.customerAddress() == null ? 0 : this.customerAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewBGPPeer)) {
            return false;
        }
        NewBGPPeer other = (NewBGPPeer)obj;
        if (other.asn() == null ^ this.asn() == null) {
            return false;
        }
        if (other.asn() != null && !other.asn().equals(this.asn())) {
            return false;
        }
        if (other.authKey() == null ^ this.authKey() == null) {
            return false;
        }
        if (other.authKey() != null && !other.authKey().equals(this.authKey())) {
            return false;
        }
        if (other.addressFamily() == null ^ this.addressFamily() == null) {
            return false;
        }
        if (other.addressFamily() != null && !other.addressFamily().equals(this.addressFamily())) {
            return false;
        }
        if (other.amazonAddress() == null ^ this.amazonAddress() == null) {
            return false;
        }
        if (other.amazonAddress() != null && !other.amazonAddress().equals(this.amazonAddress())) {
            return false;
        }
        if (other.customerAddress() == null ^ this.customerAddress() == null) {
            return false;
        }
        return other.customerAddress() == null || other.customerAddress().equals(this.customerAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.asn() != null) {
            sb.append("Asn: ").append(this.asn()).append(",");
        }
        if (this.authKey() != null) {
            sb.append("AuthKey: ").append(this.authKey()).append(",");
        }
        if (this.addressFamily() != null) {
            sb.append("AddressFamily: ").append(this.addressFamily()).append(",");
        }
        if (this.amazonAddress() != null) {
            sb.append("AmazonAddress: ").append(this.amazonAddress()).append(",");
        }
        if (this.customerAddress() != null) {
            sb.append("CustomerAddress: ").append(this.customerAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewBGPPeerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer asn;
        private String authKey;
        private String addressFamily;
        private String amazonAddress;
        private String customerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NewBGPPeer model) {
            this.setAsn(model.asn);
            this.setAuthKey(model.authKey);
            this.setAddressFamily(model.addressFamily);
            this.setAmazonAddress(model.amazonAddress);
            this.setCustomerAddress(model.customerAddress);
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final void setAddressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public NewBGPPeer build() {
            return new NewBGPPeer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NewBGPPeer> {
        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);
    }
}

