/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInterconnectLoaRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeInterconnectLoaRequest> {
    private static final SdkField<String> INTERCONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInterconnectLoaRequest.getter(DescribeInterconnectLoaRequest::interconnectId)).setter(DescribeInterconnectLoaRequest.setter(Builder::interconnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectId").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInterconnectLoaRequest.getter(DescribeInterconnectLoaRequest::providerName)).setter(DescribeInterconnectLoaRequest.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<String> LOA_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInterconnectLoaRequest.getter(DescribeInterconnectLoaRequest::loaContentTypeAsString)).setter(DescribeInterconnectLoaRequest.setter(Builder::loaContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_ID_FIELD, PROVIDER_NAME_FIELD, LOA_CONTENT_TYPE_FIELD));
    private final String interconnectId;
    private final String providerName;
    private final String loaContentType;

    private DescribeInterconnectLoaRequest(BuilderImpl builder) {
        super(builder);
        this.interconnectId = builder.interconnectId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public String providerName() {
        return this.providerName;
    }

    public LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public String loaContentTypeAsString() {
        return this.loaContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContentTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInterconnectLoaRequest)) {
            return false;
        }
        DescribeInterconnectLoaRequest other = (DescribeInterconnectLoaRequest)((Object)obj);
        return Objects.equals(this.interconnectId(), other.interconnectId()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInterconnectLoaRequest").add("InterconnectId", (Object)this.interconnectId()).add("ProviderName", (Object)this.providerName()).add("LoaContentType", (Object)this.loaContentTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.ofNullable(clazz.cast(this.interconnectId()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "loaContentType": {
                return Optional.ofNullable(clazz.cast(this.loaContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInterconnectLoaRequest, T> g) {
        return obj -> g.apply((DescribeInterconnectLoaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String interconnectId;
        private String providerName;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInterconnectLoaRequest model) {
            super(model);
            this.interconnectId(model.interconnectId);
            this.providerName(model.providerName);
            this.loaContentType(model.loaContentType);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInterconnectLoaRequest build() {
            return new DescribeInterconnectLoaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInterconnectLoaRequest> {
        public Builder interconnectId(String var1);

        public Builder providerName(String var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

