/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.AddressFamily;
import software.amazon.awssdk.services.directconnect.model.BGPPeerState;
import software.amazon.awssdk.services.directconnect.model.BGPStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BGPPeer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BGPPeer> {
    private static final SdkField<Integer> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BGPPeer.getter(BGPPeer::asn)).setter(BGPPeer.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()}).build();
    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::authKey)).setter(BGPPeer.setter(Builder::authKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::addressFamilyAsString)).setter(BGPPeer.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()}).build();
    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::amazonAddress)).setter(BGPPeer.setter(Builder::amazonAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()}).build();
    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::customerAddress)).setter(BGPPeer.setter(Builder::customerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()}).build();
    private static final SdkField<String> BGP_PEER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::bgpPeerStateAsString)).setter(BGPPeer.setter(Builder::bgpPeerState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeerState").build()}).build();
    private static final SdkField<String> BGP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::bgpStatusAsString)).setter(BGPPeer.setter(Builder::bgpStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpStatus").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BGPPeer.getter(BGPPeer::awsDeviceV2)).setter(BGPPeer.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, AUTH_KEY_FIELD, ADDRESS_FAMILY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, BGP_PEER_STATE_FIELD, BGP_STATUS_FIELD, AWS_DEVICE_V2_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer asn;
    private final String authKey;
    private final String addressFamily;
    private final String amazonAddress;
    private final String customerAddress;
    private final String bgpPeerState;
    private final String bgpStatus;
    private final String awsDeviceV2;

    private BGPPeer(BuilderImpl builder) {
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.bgpPeerState = builder.bgpPeerState;
        this.bgpStatus = builder.bgpStatus;
        this.awsDeviceV2 = builder.awsDeviceV2;
    }

    public Integer asn() {
        return this.asn;
    }

    public String authKey() {
        return this.authKey;
    }

    public AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public String addressFamilyAsString() {
        return this.addressFamily;
    }

    public String amazonAddress() {
        return this.amazonAddress;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    public BGPPeerState bgpPeerState() {
        return BGPPeerState.fromValue(this.bgpPeerState);
    }

    public String bgpPeerStateAsString() {
        return this.bgpPeerState;
    }

    public BGPStatus bgpStatus() {
        return BGPStatus.fromValue(this.bgpStatus);
    }

    public String bgpStatusAsString() {
        return this.bgpStatus;
    }

    public String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpPeerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BGPPeer)) {
            return false;
        }
        BGPPeer other = (BGPPeer)obj;
        return Objects.equals(this.asn(), other.asn()) && Objects.equals(this.authKey(), other.authKey()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.amazonAddress(), other.amazonAddress()) && Objects.equals(this.customerAddress(), other.customerAddress()) && Objects.equals(this.bgpPeerStateAsString(), other.bgpPeerStateAsString()) && Objects.equals(this.bgpStatusAsString(), other.bgpStatusAsString()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2());
    }

    public String toString() {
        return ToString.builder((String)"BGPPeer").add("Asn", (Object)this.asn()).add("AuthKey", (Object)this.authKey()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("AmazonAddress", (Object)this.amazonAddress()).add("CustomerAddress", (Object)this.customerAddress()).add("BgpPeerState", (Object)this.bgpPeerStateAsString()).add("BgpStatus", (Object)this.bgpStatusAsString()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "authKey": {
                return Optional.ofNullable(clazz.cast(this.authKey()));
            }
            case "addressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "amazonAddress": {
                return Optional.ofNullable(clazz.cast(this.amazonAddress()));
            }
            case "customerAddress": {
                return Optional.ofNullable(clazz.cast(this.customerAddress()));
            }
            case "bgpPeerState": {
                return Optional.ofNullable(clazz.cast(this.bgpPeerStateAsString()));
            }
            case "bgpStatus": {
                return Optional.ofNullable(clazz.cast(this.bgpStatusAsString()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BGPPeer, T> g) {
        return obj -> g.apply((BGPPeer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer asn;
        private String authKey;
        private String addressFamily;
        private String amazonAddress;
        private String customerAddress;
        private String bgpPeerState;
        private String bgpStatus;
        private String awsDeviceV2;

        private BuilderImpl() {
        }

        private BuilderImpl(BGPPeer model) {
            this.asn(model.asn);
            this.authKey(model.authKey);
            this.addressFamily(model.addressFamily);
            this.amazonAddress(model.amazonAddress);
            this.customerAddress(model.customerAddress);
            this.bgpPeerState(model.bgpPeerState);
            this.bgpStatus(model.bgpStatus);
            this.awsDeviceV2(model.awsDeviceV2);
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getAuthKey() {
            return this.authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily.toString());
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getAmazonAddress() {
            return this.amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        public final String getBgpPeerState() {
            return this.bgpPeerState;
        }

        @Override
        public final Builder bgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
            return this;
        }

        @Override
        public final Builder bgpPeerState(BGPPeerState bgpPeerState) {
            this.bgpPeerState(bgpPeerState.toString());
            return this;
        }

        public final void setBgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
        }

        public final String getBgpStatus() {
            return this.bgpStatus;
        }

        @Override
        public final Builder bgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        @Override
        public final Builder bgpStatus(BGPStatus bgpStatus) {
            this.bgpStatus(bgpStatus.toString());
            return this;
        }

        public final void setBgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        public BGPPeer build() {
            return new BGPPeer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BGPPeer> {
        public Builder asn(Integer var1);

        public Builder authKey(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder amazonAddress(String var1);

        public Builder customerAddress(String var1);

        public Builder bgpPeerState(String var1);

        public Builder bgpPeerState(BGPPeerState var1);

        public Builder bgpStatus(String var1);

        public Builder bgpStatus(BGPStatus var1);

        public Builder awsDeviceV2(String var1);
    }
}

