/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.VirtualGateway;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VirtualGatewayMarshaller {
    private static final MarshallingInfo<String> VIRTUALGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualGatewayId").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALGATEWAYSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualGatewayState").isBinary(false).build();
    private static final VirtualGatewayMarshaller INSTANCE = new VirtualGatewayMarshaller();

    private VirtualGatewayMarshaller() {
    }

    public static VirtualGatewayMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VirtualGateway virtualGateway, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)virtualGateway, (String)"virtualGateway");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)virtualGateway.virtualGatewayId(), VIRTUALGATEWAYID_BINDING);
            protocolMarshaller.marshall((Object)virtualGateway.virtualGatewayState(), VIRTUALGATEWAYSTATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

