/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NewPublicVirtualInterfaceAllocationMarshaller {
    private static final MarshallingInfo<String> VIRTUALINTERFACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceName").isBinary(false).build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").isBinary(false).build();
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").isBinary(false).build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").isBinary(false).build();
    private static final MarshallingInfo<List> ROUTEFILTERPREFIXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("routeFilterPrefixes").isBinary(false).build();
    private static final NewPublicVirtualInterfaceAllocationMarshaller INSTANCE = new NewPublicVirtualInterfaceAllocationMarshaller();

    private NewPublicVirtualInterfaceAllocationMarshaller() {
    }

    public static NewPublicVirtualInterfaceAllocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)newPublicVirtualInterfaceAllocation, (String)"newPublicVirtualInterfaceAllocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.virtualInterfaceName(), VIRTUALINTERFACENAME_BINDING);
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.vlan(), VLAN_BINDING);
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.customerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)newPublicVirtualInterfaceAllocation.addressFamilyAsString(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall(newPublicVirtualInterfaceAllocation.routeFilterPrefixes(), ROUTEFILTERPREFIXES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

