/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NewPrivateVirtualInterfaceMarshaller {
    private static final MarshallingInfo<String> VIRTUALINTERFACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceName").isBinary(false).build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").isBinary(false).build();
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").isBinary(false).build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualGatewayId").isBinary(false).build();
    private static final MarshallingInfo<String> DIRECTCONNECTGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("directConnectGatewayId").isBinary(false).build();
    private static final NewPrivateVirtualInterfaceMarshaller INSTANCE = new NewPrivateVirtualInterfaceMarshaller();

    private NewPrivateVirtualInterfaceMarshaller() {
    }

    public static NewPrivateVirtualInterfaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NewPrivateVirtualInterface newPrivateVirtualInterface, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)newPrivateVirtualInterface, (String)"newPrivateVirtualInterface");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.virtualInterfaceName(), VIRTUALINTERFACENAME_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.vlan(), VLAN_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.customerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.addressFamilyAsString(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.virtualGatewayId(), VIRTUALGATEWAYID_BINDING);
            protocolMarshaller.marshall((Object)newPrivateVirtualInterface.directConnectGatewayId(), DIRECTCONNECTGATEWAYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

