/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.Lag;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LagMarshaller {
    private static final MarshallingInfo<String> CONNECTIONSBANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionsBandwidth").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFCONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfConnections").isBinary(false).build();
    private static final MarshallingInfo<String> LAGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagId").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").isBinary(false).build();
    private static final MarshallingInfo<String> LAGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagName").isBinary(false).build();
    private static final MarshallingInfo<String> LAGSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagState").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIMUMLINKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumLinks").isBinary(false).build();
    private static final MarshallingInfo<String> AWSDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDevice").isBinary(false).build();
    private static final MarshallingInfo<String> AWSDEVICEV2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDeviceV2").isBinary(false).build();
    private static final MarshallingInfo<List> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connections").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLOWSHOSTEDCONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowsHostedConnections").isBinary(false).build();
    private static final LagMarshaller INSTANCE = new LagMarshaller();

    private LagMarshaller() {
    }

    public static LagMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Lag lag, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lag, (String)"lag");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lag.connectionsBandwidth(), CONNECTIONSBANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)lag.numberOfConnections(), NUMBEROFCONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)lag.lagId(), LAGID_BINDING);
            protocolMarshaller.marshall((Object)lag.ownerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)lag.lagName(), LAGNAME_BINDING);
            protocolMarshaller.marshall((Object)lag.lagStateAsString(), LAGSTATE_BINDING);
            protocolMarshaller.marshall((Object)lag.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)lag.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)lag.minimumLinks(), MINIMUMLINKS_BINDING);
            protocolMarshaller.marshall((Object)lag.awsDevice(), AWSDEVICE_BINDING);
            protocolMarshaller.marshall((Object)lag.awsDeviceV2(), AWSDEVICEV2_BINDING);
            protocolMarshaller.marshall(lag.connections(), CONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)lag.allowsHostedConnections(), ALLOWSHOSTEDCONNECTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

