/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest;
import software.amazon.awssdk.services.directconnect.transform.DescribeLocationsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeLocationsRequestMarshaller
implements Marshaller<Request<DescribeLocationsRequest>, DescribeLocationsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(false).operationIdentifier("OvertureService.DescribeLocations").serviceName("AWS Direct Connect").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeLocationsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeLocationsRequest> marshall(DescribeLocationsRequest describeLocationsRequest) {
        Validate.paramNotNull((Object)((Object)describeLocationsRequest), (String)"describeLocationsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeLocationsRequest);
            protocolMarshaller.startMarshalling();
            DescribeLocationsRequestModelMarshaller.getInstance().marshall(describeLocationsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

