/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewaysRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeDirectConnectGatewaysRequestMarshaller
implements Marshaller<Request<DescribeDirectConnectGatewaysRequest>, DescribeDirectConnectGatewaysRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("OvertureService.DescribeDirectConnectGateways").serviceName("AWS Direct Connect").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeDirectConnectGatewaysRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeDirectConnectGatewaysRequest> marshall(DescribeDirectConnectGatewaysRequest describeDirectConnectGatewaysRequest) {
        Validate.paramNotNull((Object)((Object)describeDirectConnectGatewaysRequest), (String)"describeDirectConnectGatewaysRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeDirectConnectGatewaysRequest);
            protocolMarshaller.startMarshalling();
            DescribeDirectConnectGatewaysRequestModelMarshaller.getInstance().marshall(describeDirectConnectGatewaysRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

