/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDirectConnectGatewayRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateDirectConnectGatewayRequest> {
    private final String directConnectGatewayName;
    private final Long amazonSideAsn;

    private CreateDirectConnectGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayName = builder.directConnectGatewayName;
        this.amazonSideAsn = builder.amazonSideAsn;
    }

    public String directConnectGatewayName() {
        return this.directConnectGatewayName;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectConnectGatewayRequest)) {
            return false;
        }
        CreateDirectConnectGatewayRequest other = (CreateDirectConnectGatewayRequest)((Object)obj);
        return Objects.equals(this.directConnectGatewayName(), other.directConnectGatewayName()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn());
    }

    public String toString() {
        return ToString.builder((String)"CreateDirectConnectGatewayRequest").add("DirectConnectGatewayName", (Object)this.directConnectGatewayName()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayName": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayName()));
            }
            case "amazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String directConnectGatewayName;
        private Long amazonSideAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectConnectGatewayRequest model) {
            super(model);
            this.directConnectGatewayName(model.directConnectGatewayName);
            this.amazonSideAsn(model.amazonSideAsn);
        }

        public final String getDirectConnectGatewayName() {
            return this.directConnectGatewayName;
        }

        @Override
        public final Builder directConnectGatewayName(String directConnectGatewayName) {
            this.directConnectGatewayName = directConnectGatewayName;
            return this;
        }

        public final void setDirectConnectGatewayName(String directConnectGatewayName) {
            this.directConnectGatewayName = directConnectGatewayName;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectConnectGatewayRequest build() {
            return new CreateDirectConnectGatewayRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, CreateDirectConnectGatewayRequest> {
        public Builder directConnectGatewayName(String var1);

        public Builder amazonSideAsn(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

