/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.VirtualInterface;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VirtualInterfaceMarshaller {
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceId").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceType").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceName").isBinary(false).build();
    private static final MarshallingInfo<Integer> VLAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vlan").isBinary(false).build();
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").isBinary(false).build();
    private static final MarshallingInfo<Long> AMAZONSIDEASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonSideAsn").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").isBinary(false).build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceState").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERROUTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerRouterConfig").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualGatewayId").isBinary(false).build();
    private static final MarshallingInfo<String> DIRECTCONNECTGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("directConnectGatewayId").isBinary(false).build();
    private static final MarshallingInfo<List> ROUTEFILTERPREFIXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("routeFilterPrefixes").isBinary(false).build();
    private static final MarshallingInfo<List> BGPPEERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpPeers").isBinary(false).build();
    private static final VirtualInterfaceMarshaller INSTANCE = new VirtualInterfaceMarshaller();

    private VirtualInterfaceMarshaller() {
    }

    public static VirtualInterfaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VirtualInterface virtualInterface, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)virtualInterface, (String)"virtualInterface");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)virtualInterface.ownerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceId(), VIRTUALINTERFACEID_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.connectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceType(), VIRTUALINTERFACETYPE_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceName(), VIRTUALINTERFACENAME_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.vlan(), VLAN_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.asn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.amazonSideAsn(), AMAZONSIDEASN_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.authKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.amazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.customerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.addressFamilyAsString(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualInterfaceStateAsString(), VIRTUALINTERFACESTATE_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.customerRouterConfig(), CUSTOMERROUTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.virtualGatewayId(), VIRTUALGATEWAYID_BINDING);
            protocolMarshaller.marshall((Object)virtualInterface.directConnectGatewayId(), DIRECTCONNECTGATEWAYID_BINDING);
            protocolMarshaller.marshall(virtualInterface.routeFilterPrefixes(), ROUTEFILTERPREFIXES_BINDING);
            protocolMarshaller.marshall(virtualInterface.bgpPeers(), BGPPEERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

