/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DirectConnectGatewayAttachmentMarshaller {
    private static final MarshallingInfo<String> DIRECTCONNECTGATEWAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("directConnectGatewayId").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceId").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACEREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceRegion").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALINTERFACEOWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualInterfaceOwnerAccount").isBinary(false).build();
    private static final MarshallingInfo<String> ATTACHMENTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentState").isBinary(false).build();
    private static final MarshallingInfo<String> STATECHANGEERROR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateChangeError").isBinary(false).build();
    private static final DirectConnectGatewayAttachmentMarshaller INSTANCE = new DirectConnectGatewayAttachmentMarshaller();

    private DirectConnectGatewayAttachmentMarshaller() {
    }

    public static DirectConnectGatewayAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DirectConnectGatewayAttachment directConnectGatewayAttachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)directConnectGatewayAttachment, (String)"directConnectGatewayAttachment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)directConnectGatewayAttachment.directConnectGatewayId(), DIRECTCONNECTGATEWAYID_BINDING);
            protocolMarshaller.marshall((Object)directConnectGatewayAttachment.virtualInterfaceId(), VIRTUALINTERFACEID_BINDING);
            protocolMarshaller.marshall((Object)directConnectGatewayAttachment.virtualInterfaceRegion(), VIRTUALINTERFACEREGION_BINDING);
            protocolMarshaller.marshall((Object)directConnectGatewayAttachment.virtualInterfaceOwnerAccount(), VIRTUALINTERFACEOWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)directConnectGatewayAttachment.attachmentStateAsString(), ATTACHMENTSTATE_BINDING);
            protocolMarshaller.marshall((Object)directConnectGatewayAttachment.stateChangeError(), STATECHANGEERROR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

