/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectLoaRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeInterconnectLoaRequestModelMarshaller {
    private static final MarshallingInfo<String> INTERCONNECTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerName").isBinary(false).build();
    private static final MarshallingInfo<String> LOACONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContentType").isBinary(false).build();
    private static final DescribeInterconnectLoaRequestModelMarshaller INSTANCE = new DescribeInterconnectLoaRequestModelMarshaller();

    private DescribeInterconnectLoaRequestModelMarshaller() {
    }

    public static DescribeInterconnectLoaRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeInterconnectLoaRequest describeInterconnectLoaRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeInterconnectLoaRequest), (String)"describeInterconnectLoaRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeInterconnectLoaRequest.interconnectId(), INTERCONNECTID_BINDING);
            protocolMarshaller.marshall((Object)describeInterconnectLoaRequest.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)describeInterconnectLoaRequest.loaContentTypeAsString(), LOACONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

