/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.services.directconnect.transform.LoaMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Loa
implements StructuredPojo,
ToCopyableBuilder<Builder, Loa> {
    private final ByteBuffer loaContent;
    private final String loaContentType;

    private Loa(BuilderImpl builder) {
        this.loaContent = builder.loaContent;
        this.loaContentType = builder.loaContentType;
    }

    public ByteBuffer loaContent() {
        return this.loaContent == null ? null : this.loaContent.asReadOnlyBuffer();
    }

    public LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public String loaContentTypeAsString() {
        return this.loaContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContentTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Loa)) {
            return false;
        }
        Loa other = (Loa)obj;
        return Objects.equals(this.loaContent(), other.loaContent()) && Objects.equals(this.loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Loa").add("LoaContent", (Object)this.loaContent()).add("LoaContentType", (Object)this.loaContentTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loaContent": {
                return Optional.of(clazz.cast(this.loaContent()));
            }
            case "loaContentType": {
                return Optional.of(clazz.cast(this.loaContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer loaContent;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(Loa model) {
            this.loaContent(model.loaContent);
            this.loaContentType(model.loaContentType);
        }

        public final ByteBuffer getLoaContent() {
            return this.loaContent;
        }

        @Override
        public final Builder loaContent(ByteBuffer loaContent) {
            this.loaContent = StandardMemberCopier.copy((ByteBuffer)loaContent);
            return this;
        }

        public final void setLoaContent(ByteBuffer loaContent) {
            this.loaContent = StandardMemberCopier.copy((ByteBuffer)loaContent);
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        public Loa build() {
            return new Loa(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Loa> {
        public Builder loaContent(ByteBuffer var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);
    }
}

