/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.LagState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteLagResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DeleteLagResponse> {
    private final String connectionsBandwidth;
    private final Integer numberOfConnections;
    private final String lagId;
    private final String ownerAccount;
    private final String lagName;
    private final String lagState;
    private final String location;
    private final String region;
    private final Integer minimumLinks;
    private final String awsDevice;
    private final List<Connection> connections;
    private final Boolean allowsHostedConnections;

    private DeleteLagResponse(BuilderImpl builder) {
        super(builder);
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.numberOfConnections = builder.numberOfConnections;
        this.lagId = builder.lagId;
        this.ownerAccount = builder.ownerAccount;
        this.lagName = builder.lagName;
        this.lagState = builder.lagState;
        this.location = builder.location;
        this.region = builder.region;
        this.minimumLinks = builder.minimumLinks;
        this.awsDevice = builder.awsDevice;
        this.connections = builder.connections;
        this.allowsHostedConnections = builder.allowsHostedConnections;
    }

    public String connectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public Integer numberOfConnections() {
        return this.numberOfConnections;
    }

    public String lagId() {
        return this.lagId;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String lagName() {
        return this.lagName;
    }

    public LagState lagState() {
        return LagState.fromValue(this.lagState);
    }

    public String lagStateAsString() {
        return this.lagState;
    }

    public String location() {
        return this.location;
    }

    public String region() {
        return this.region;
    }

    public Integer minimumLinks() {
        return this.minimumLinks;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public List<Connection> connections() {
        return this.connections;
    }

    public Boolean allowsHostedConnections() {
        return this.allowsHostedConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionsBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsHostedConnections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLagResponse)) {
            return false;
        }
        DeleteLagResponse other = (DeleteLagResponse)((Object)obj);
        return Objects.equals(this.connectionsBandwidth(), other.connectionsBandwidth()) && Objects.equals(this.numberOfConnections(), other.numberOfConnections()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.lagName(), other.lagName()) && Objects.equals(this.lagStateAsString(), other.lagStateAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.minimumLinks(), other.minimumLinks()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.allowsHostedConnections(), other.allowsHostedConnections());
    }

    public String toString() {
        return ToString.builder((String)"DeleteLagResponse").add("ConnectionsBandwidth", (Object)this.connectionsBandwidth()).add("NumberOfConnections", (Object)this.numberOfConnections()).add("LagId", (Object)this.lagId()).add("OwnerAccount", (Object)this.ownerAccount()).add("LagName", (Object)this.lagName()).add("LagState", (Object)this.lagStateAsString()).add("Location", (Object)this.location()).add("Region", (Object)this.region()).add("MinimumLinks", (Object)this.minimumLinks()).add("AwsDevice", (Object)this.awsDevice()).add("Connections", this.connections()).add("AllowsHostedConnections", (Object)this.allowsHostedConnections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionsBandwidth": {
                return Optional.of(clazz.cast(this.connectionsBandwidth()));
            }
            case "numberOfConnections": {
                return Optional.of(clazz.cast(this.numberOfConnections()));
            }
            case "lagId": {
                return Optional.of(clazz.cast(this.lagId()));
            }
            case "ownerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "lagName": {
                return Optional.of(clazz.cast(this.lagName()));
            }
            case "lagState": {
                return Optional.of(clazz.cast(this.lagStateAsString()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "minimumLinks": {
                return Optional.of(clazz.cast(this.minimumLinks()));
            }
            case "awsDevice": {
                return Optional.of(clazz.cast(this.awsDevice()));
            }
            case "connections": {
                return Optional.of(clazz.cast(this.connections()));
            }
            case "allowsHostedConnections": {
                return Optional.of(clazz.cast(this.allowsHostedConnections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String connectionsBandwidth;
        private Integer numberOfConnections;
        private String lagId;
        private String ownerAccount;
        private String lagName;
        private String lagState;
        private String location;
        private String region;
        private Integer minimumLinks;
        private String awsDevice;
        private List<Connection> connections;
        private Boolean allowsHostedConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLagResponse model) {
            super(model);
            this.connectionsBandwidth(model.connectionsBandwidth);
            this.numberOfConnections(model.numberOfConnections);
            this.lagId(model.lagId);
            this.ownerAccount(model.ownerAccount);
            this.lagName(model.lagName);
            this.lagState(model.lagState);
            this.location(model.location);
            this.region(model.region);
            this.minimumLinks(model.minimumLinks);
            this.awsDevice(model.awsDevice);
            this.connections(model.connections);
            this.allowsHostedConnections(model.allowsHostedConnections);
        }

        public final String getConnectionsBandwidth() {
            return this.connectionsBandwidth;
        }

        @Override
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        public final Integer getNumberOfConnections() {
            return this.numberOfConnections;
        }

        @Override
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getLagName() {
            return this.lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final String getLagState() {
            return this.lagState;
        }

        @Override
        public final Builder lagState(String lagState) {
            this.lagState = lagState;
            return this;
        }

        @Override
        public final Builder lagState(LagState lagState) {
            this.lagState(lagState.toString());
            return this;
        }

        public final void setLagState(String lagState) {
            this.lagState = lagState;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Integer getMinimumLinks() {
            return this.minimumLinks;
        }

        @Override
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final Collection<Connection.Builder> getConnections() {
            return this.connections != null ? (Collection)this.connections.stream().map(Connection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<Connection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (Connection)((Connection.Builder)Connection.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionListCopier.copyFromBuilder(connections);
        }

        public final Boolean getAllowsHostedConnections() {
            return this.allowsHostedConnections;
        }

        @Override
        public final Builder allowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
            return this;
        }

        public final void setAllowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
        }

        @Override
        public DeleteLagResponse build() {
            return new DeleteLagResponse(this);
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    CopyableBuilder<Builder, DeleteLagResponse> {
        public Builder connectionsBandwidth(String var1);

        public Builder numberOfConnections(Integer var1);

        public Builder lagId(String var1);

        public Builder ownerAccount(String var1);

        public Builder lagName(String var1);

        public Builder lagState(String var1);

        public Builder lagState(LagState var1);

        public Builder location(String var1);

        public Builder region(String var1);

        public Builder minimumLinks(Integer var1);

        public Builder awsDevice(String var1);

        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);

        public Builder connections(Consumer<Connection.Builder> ... var1);

        public Builder allowsHostedConnections(Boolean var1);
    }
}

