/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteBGPPeerRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DeleteBGPPeerRequest> {
    private final String virtualInterfaceId;
    private final Integer asn;
    private final String customerAddress;

    private DeleteBGPPeerRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.asn = builder.asn;
        this.customerAddress = builder.customerAddress;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public Integer asn() {
        return this.asn;
    }

    public String customerAddress() {
        return this.customerAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBGPPeerRequest)) {
            return false;
        }
        DeleteBGPPeerRequest other = (DeleteBGPPeerRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.asn(), other.asn()) && Objects.equals(this.customerAddress(), other.customerAddress());
    }

    public String toString() {
        return ToString.builder((String)"DeleteBGPPeerRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("Asn", (Object)this.asn()).add("CustomerAddress", (Object)this.customerAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.of(clazz.cast(this.virtualInterfaceId()));
            }
            case "asn": {
                return Optional.of(clazz.cast(this.asn()));
            }
            case "customerAddress": {
                return Optional.of(clazz.cast(this.customerAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private Integer asn;
        private String customerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBGPPeerRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.asn(model.asn);
            this.customerAddress(model.customerAddress);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final Integer getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        public final String getCustomerAddress() {
            return this.customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteBGPPeerRequest build() {
            return new DeleteBGPPeerRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, DeleteBGPPeerRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder asn(Integer var1);

        public Builder customerAddress(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

