/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateConnectionRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateConnectionRequest> {
    private final String location;
    private final String bandwidth;
    private final String connectionName;
    private final String lagId;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.connectionName = builder.connectionName;
        this.lagId = builder.lagId;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public String lagId() {
        return this.lagId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.lagId(), other.lagId());
    }

    public String toString() {
        return ToString.builder((String)"CreateConnectionRequest").add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("ConnectionName", (Object)this.connectionName()).add("LagId", (Object)this.lagId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.of(clazz.cast(this.bandwidth()));
            }
            case "connectionName": {
                return Optional.of(clazz.cast(this.connectionName()));
            }
            case "lagId": {
                return Optional.of(clazz.cast(this.lagId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String location;
        private String bandwidth;
        private String connectionName;
        private String lagId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.connectionName(model.connectionName);
            this.lagId(model.lagId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, CreateConnectionRequest> {
        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder connectionName(String var1);

        public Builder lagId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

