/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateHostedConnectionRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocateHostedConnectionRequest> {
    private final String connectionId;
    private final String ownerAccount;
    private final String bandwidth;
    private final String connectionName;
    private final Integer vlan;

    private AllocateHostedConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.bandwidth = builder.bandwidth;
        this.connectionName = builder.connectionName;
        this.vlan = builder.vlan;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public Integer vlan() {
        return this.vlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostedConnectionRequest)) {
            return false;
        }
        AllocateHostedConnectionRequest other = (AllocateHostedConnectionRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.vlan(), other.vlan());
    }

    public String toString() {
        return ToString.builder((String)"AllocateHostedConnectionRequest").add("ConnectionId", (Object)this.connectionId()).add("OwnerAccount", (Object)this.ownerAccount()).add("Bandwidth", (Object)this.bandwidth()).add("ConnectionName", (Object)this.connectionName()).add("Vlan", (Object)this.vlan()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.of(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "bandwidth": {
                return Optional.of(clazz.cast(this.bandwidth()));
            }
            case "connectionName": {
                return Optional.of(clazz.cast(this.connectionName()));
            }
            case "vlan": {
                return Optional.of(clazz.cast(this.vlan()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private String bandwidth;
        private String connectionName;
        private Integer vlan;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostedConnectionRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.bandwidth(model.bandwidth);
            this.connectionName(model.connectionName);
            this.vlan(model.vlan);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostedConnectionRequest build() {
            return new AllocateHostedConnectionRequest(this);
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    CopyableBuilder<Builder, AllocateHostedConnectionRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder bandwidth(String var1);

        public Builder connectionName(String var1);

        public Builder vlan(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

