/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.directconnect.model.ResourceTag;
import software.amazon.awssdk.services.directconnect.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final List<ResourceTag> resourceTags;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.resourceTags = builder.resourceTags;
    }

    public List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceTags() == null ? 0 : this.resourceTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        if (other.resourceTags() == null ^ this.resourceTags() == null) {
            return false;
        }
        return other.resourceTags() == null || other.resourceTags().equals(this.resourceTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceTags() != null) {
            sb.append("ResourceTags: ").append(this.resourceTags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ResourceTag> resourceTags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            this.setResourceTags(model.resourceTags);
        }

        public final Collection<ResourceTag> getResourceTags() {
            return this.resourceTags;
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            if (this.resourceTags == null) {
                this.resourceTags = new SdkInternalList(resourceTags.length);
            }
            for (ResourceTag e : resourceTags) {
                this.resourceTags.add(e);
            }
            return this;
        }

        public final void setResourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
        }

        @SafeVarargs
        public final void setResourceTags(ResourceTag ... resourceTags) {
            if (this.resourceTags == null) {
                this.resourceTags = new SdkInternalList(resourceTags.length);
            }
            for (ResourceTag e : resourceTags) {
                this.resourceTags.add(e);
            }
        }

        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);
    }
}

