/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLoaRequest> {
    private final String connectionId;
    private final String providerName;
    private final String loaContentType;

    private DescribeLoaRequest(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String providerName() {
        return this.providerName;
    }

    public String loaContentType() {
        return this.loaContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectionId() == null ? 0 : this.connectionId().hashCode());
        hashCode = 31 * hashCode + (this.providerName() == null ? 0 : this.providerName().hashCode());
        hashCode = 31 * hashCode + (this.loaContentType() == null ? 0 : this.loaContentType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoaRequest)) {
            return false;
        }
        DescribeLoaRequest other = (DescribeLoaRequest)((Object)obj);
        if (other.connectionId() == null ^ this.connectionId() == null) {
            return false;
        }
        if (other.connectionId() != null && !other.connectionId().equals(this.connectionId())) {
            return false;
        }
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.loaContentType() == null ^ this.loaContentType() == null) {
            return false;
        }
        return other.loaContentType() == null || other.loaContentType().equals(this.loaContentType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectionId() != null) {
            sb.append("ConnectionId: ").append(this.connectionId()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.loaContentType() != null) {
            sb.append("LoaContentType: ").append(this.loaContentType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String connectionId;
        private String providerName;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoaRequest model) {
            this.setConnectionId(model.connectionId);
            this.setProviderName(model.providerName);
            this.setLoaContentType(model.loaContentType);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        public final void setLoaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType.toString());
        }

        public DescribeLoaRequest build() {
            return new DescribeLoaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoaRequest> {
        public Builder connectionId(String var1);

        public Builder providerName(String var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);
    }
}

