/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetailsCopier;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalySourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalySourceDetails> {
    private static final SdkField<List<CloudWatchMetricsDetail>> CLOUD_WATCH_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchMetrics").getter(AnomalySourceDetails.getter(AnomalySourceDetails::cloudWatchMetrics)).setter(AnomalySourceDetails.setter(Builder::cloudWatchMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchMetricsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PerformanceInsightsMetricsDetail>> PERFORMANCE_INSIGHTS_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PerformanceInsightsMetrics").getter(AnomalySourceDetails.getter(AnomalySourceDetails::performanceInsightsMetrics)).setter(AnomalySourceDetails.setter(Builder::performanceInsightsMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerformanceInsightsMetricsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_METRICS_FIELD, PERFORMANCE_INSIGHTS_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnomalySourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CloudWatchMetricsDetail> cloudWatchMetrics;
    private final List<PerformanceInsightsMetricsDetail> performanceInsightsMetrics;

    private AnomalySourceDetails(BuilderImpl builder) {
        this.cloudWatchMetrics = builder.cloudWatchMetrics;
        this.performanceInsightsMetrics = builder.performanceInsightsMetrics;
    }

    public final boolean hasCloudWatchMetrics() {
        return this.cloudWatchMetrics != null && !(this.cloudWatchMetrics instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchMetricsDetail> cloudWatchMetrics() {
        return this.cloudWatchMetrics;
    }

    public final boolean hasPerformanceInsightsMetrics() {
        return this.performanceInsightsMetrics != null && !(this.performanceInsightsMetrics instanceof SdkAutoConstructList);
    }

    public final List<PerformanceInsightsMetricsDetail> performanceInsightsMetrics() {
        return this.performanceInsightsMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchMetrics() ? this.cloudWatchMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPerformanceInsightsMetrics() ? this.performanceInsightsMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalySourceDetails)) {
            return false;
        }
        AnomalySourceDetails other = (AnomalySourceDetails)obj;
        return this.hasCloudWatchMetrics() == other.hasCloudWatchMetrics() && Objects.equals(this.cloudWatchMetrics(), other.cloudWatchMetrics()) && this.hasPerformanceInsightsMetrics() == other.hasPerformanceInsightsMetrics() && Objects.equals(this.performanceInsightsMetrics(), other.performanceInsightsMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalySourceDetails").add("CloudWatchMetrics", this.hasCloudWatchMetrics() ? this.cloudWatchMetrics() : null).add("PerformanceInsightsMetrics", this.hasPerformanceInsightsMetrics() ? this.performanceInsightsMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchMetrics": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetrics()));
            }
            case "PerformanceInsightsMetrics": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CloudWatchMetrics", CLOUD_WATCH_METRICS_FIELD);
        map.put("PerformanceInsightsMetrics", PERFORMANCE_INSIGHTS_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalySourceDetails, T> g) {
        return obj -> g.apply((AnomalySourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CloudWatchMetricsDetail> cloudWatchMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<PerformanceInsightsMetricsDetail> performanceInsightsMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalySourceDetails model) {
            this.cloudWatchMetrics(model.cloudWatchMetrics);
            this.performanceInsightsMetrics(model.performanceInsightsMetrics);
        }

        public final List<CloudWatchMetricsDetail.Builder> getCloudWatchMetrics() {
            List<CloudWatchMetricsDetail.Builder> result = CloudWatchMetricsDetailsCopier.copyToBuilder(this.cloudWatchMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchMetrics(Collection<CloudWatchMetricsDetail.BuilderImpl> cloudWatchMetrics) {
            this.cloudWatchMetrics = CloudWatchMetricsDetailsCopier.copyFromBuilder(cloudWatchMetrics);
        }

        @Override
        public final Builder cloudWatchMetrics(Collection<CloudWatchMetricsDetail> cloudWatchMetrics) {
            this.cloudWatchMetrics = CloudWatchMetricsDetailsCopier.copy(cloudWatchMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(CloudWatchMetricsDetail ... cloudWatchMetrics) {
            this.cloudWatchMetrics(Arrays.asList(cloudWatchMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(Consumer<CloudWatchMetricsDetail.Builder> ... cloudWatchMetrics) {
            this.cloudWatchMetrics(Stream.of(cloudWatchMetrics).map(c -> (CloudWatchMetricsDetail)((CloudWatchMetricsDetail.Builder)CloudWatchMetricsDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PerformanceInsightsMetricsDetail.Builder> getPerformanceInsightsMetrics() {
            List<PerformanceInsightsMetricsDetail.Builder> result = PerformanceInsightsMetricsDetailsCopier.copyToBuilder(this.performanceInsightsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPerformanceInsightsMetrics(Collection<PerformanceInsightsMetricsDetail.BuilderImpl> performanceInsightsMetrics) {
            this.performanceInsightsMetrics = PerformanceInsightsMetricsDetailsCopier.copyFromBuilder(performanceInsightsMetrics);
        }

        @Override
        public final Builder performanceInsightsMetrics(Collection<PerformanceInsightsMetricsDetail> performanceInsightsMetrics) {
            this.performanceInsightsMetrics = PerformanceInsightsMetricsDetailsCopier.copy(performanceInsightsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder performanceInsightsMetrics(PerformanceInsightsMetricsDetail ... performanceInsightsMetrics) {
            this.performanceInsightsMetrics(Arrays.asList(performanceInsightsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder performanceInsightsMetrics(Consumer<PerformanceInsightsMetricsDetail.Builder> ... performanceInsightsMetrics) {
            this.performanceInsightsMetrics(Stream.of(performanceInsightsMetrics).map(c -> (PerformanceInsightsMetricsDetail)((PerformanceInsightsMetricsDetail.Builder)PerformanceInsightsMetricsDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnomalySourceDetails build() {
            return new AnomalySourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalySourceDetails> {
        public Builder cloudWatchMetrics(Collection<CloudWatchMetricsDetail> var1);

        public Builder cloudWatchMetrics(CloudWatchMetricsDetail ... var1);

        public Builder cloudWatchMetrics(Consumer<CloudWatchMetricsDetail.Builder> ... var1);

        public Builder performanceInsightsMetrics(Collection<PerformanceInsightsMetricsDetail> var1);

        public Builder performanceInsightsMetrics(PerformanceInsightsMetricsDetail ... var1);

        public Builder performanceInsightsMetrics(Consumer<PerformanceInsightsMetricsDetail.Builder> ... var1);
    }
}

