/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.ResourcePermission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoredResourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoredResourceIdentifier> {
    private static final SdkField<String> MONITORED_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoredResourceName").getter(MonitoredResourceIdentifier.getter(MonitoredResourceIdentifier::monitoredResourceName)).setter(MonitoredResourceIdentifier.setter(Builder::monitoredResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredResourceName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(MonitoredResourceIdentifier.getter(MonitoredResourceIdentifier::type)).setter(MonitoredResourceIdentifier.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> RESOURCE_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePermission").getter(MonitoredResourceIdentifier.getter(MonitoredResourceIdentifier::resourcePermissionAsString)).setter(MonitoredResourceIdentifier.setter(Builder::resourcePermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORED_RESOURCE_NAME_FIELD, TYPE_FIELD, RESOURCE_PERMISSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String monitoredResourceName;
    private final String type;
    private final String resourcePermission;

    private MonitoredResourceIdentifier(BuilderImpl builder) {
        this.monitoredResourceName = builder.monitoredResourceName;
        this.type = builder.type;
        this.resourcePermission = builder.resourcePermission;
    }

    public final String monitoredResourceName() {
        return this.monitoredResourceName;
    }

    public final String type() {
        return this.type;
    }

    public final ResourcePermission resourcePermission() {
        return ResourcePermission.fromValue(this.resourcePermission);
    }

    public final String resourcePermissionAsString() {
        return this.resourcePermission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePermissionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoredResourceIdentifier)) {
            return false;
        }
        MonitoredResourceIdentifier other = (MonitoredResourceIdentifier)obj;
        return Objects.equals(this.monitoredResourceName(), other.monitoredResourceName()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.resourcePermissionAsString(), other.resourcePermissionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoredResourceIdentifier").add("MonitoredResourceName", (Object)this.monitoredResourceName()).add("Type", (Object)this.type()).add("ResourcePermission", (Object)this.resourcePermissionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoredResourceName": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ResourcePermission": {
                return Optional.ofNullable(clazz.cast(this.resourcePermissionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoredResourceIdentifier, T> g) {
        return obj -> g.apply((MonitoredResourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoredResourceName;
        private String type;
        private String resourcePermission;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoredResourceIdentifier model) {
            this.monitoredResourceName(model.monitoredResourceName);
            this.type(model.type);
            this.resourcePermission(model.resourcePermission);
        }

        public final String getMonitoredResourceName() {
            return this.monitoredResourceName;
        }

        public final void setMonitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
        }

        @Override
        public final Builder monitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getResourcePermission() {
            return this.resourcePermission;
        }

        public final void setResourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
        }

        @Override
        public final Builder resourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
            return this;
        }

        @Override
        public final Builder resourcePermission(ResourcePermission resourcePermission) {
            this.resourcePermission(resourcePermission == null ? null : resourcePermission.toString());
            return this;
        }

        public MonitoredResourceIdentifier build() {
            return new MonitoredResourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoredResourceIdentifier> {
        public Builder monitoredResourceName(String var1);

        public Builder type(String var1);

        public Builder resourcePermission(String var1);

        public Builder resourcePermission(ResourcePermission var1);
    }
}

