/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InsightType {
    REACTIVE("REACTIVE"),
    PROACTIVE("PROACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InsightType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InsightType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightType> knownValues() {
        return Stream.of(InsightType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

