/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an anomaly that is related to a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationRelatedAnomaly implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationRelatedAnomaly.Builder, RecommendationRelatedAnomaly> {
    private static final SdkField<List<RecommendationRelatedAnomalyResource>> RESOURCES_FIELD = SdkField
            .<List<RecommendationRelatedAnomalyResource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(RecommendationRelatedAnomaly::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationRelatedAnomalyResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationRelatedAnomalyResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RecommendationRelatedAnomalySourceDetail>> SOURCE_DETAILS_FIELD = SdkField
            .<List<RecommendationRelatedAnomalySourceDetail>> builder(MarshallingType.LIST)
            .memberName("SourceDetails")
            .getter(getter(RecommendationRelatedAnomaly::sourceDetails))
            .setter(setter(Builder::sourceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationRelatedAnomalySourceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationRelatedAnomalySourceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD,
            SOURCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RecommendationRelatedAnomalyResource> resources;

    private final List<RecommendationRelatedAnomalySourceDetail> sourceDetails;

    private RecommendationRelatedAnomaly(BuilderImpl builder) {
        this.resources = builder.resources;
        this.sourceDetails = builder.sourceDetails;
    }

    /**
     * Returns true if the Resources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object
     * contains the name and type of the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each
     *         object contains the name and type of the resource.
     */
    public final List<RecommendationRelatedAnomalyResource> resources() {
        return resources;
    }

    /**
     * Returns true if the SourceDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSourceDetails() {
        return sourceDetails != null && !(sourceDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about where the anomalous behavior related the recommendation was found. For example, details in
     * Amazon CloudWatch metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about where the anomalous behavior related the recommendation was found. For example, details
     *         in Amazon CloudWatch metrics.
     */
    public final List<RecommendationRelatedAnomalySourceDetail> sourceDetails() {
        return sourceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceDetails() ? sourceDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationRelatedAnomaly)) {
            return false;
        }
        RecommendationRelatedAnomaly other = (RecommendationRelatedAnomaly) obj;
        return hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && hasSourceDetails() == other.hasSourceDetails() && Objects.equals(sourceDetails(), other.sourceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationRelatedAnomaly").add("Resources", hasResources() ? resources() : null)
                .add("SourceDetails", hasSourceDetails() ? sourceDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "SourceDetails":
            return Optional.ofNullable(clazz.cast(sourceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationRelatedAnomaly, T> g) {
        return obj -> g.apply((RecommendationRelatedAnomaly) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationRelatedAnomaly> {
        /**
         * <p>
         * An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object
         * contains the name and type of the resource.
         * </p>
         * 
         * @param resources
         *        An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each
         *        object contains the name and type of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<RecommendationRelatedAnomalyResource> resources);

        /**
         * <p>
         * An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object
         * contains the name and type of the resource.
         * </p>
         * 
         * @param resources
         *        An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each
         *        object contains the name and type of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(RecommendationRelatedAnomalyResource... resources);

        /**
         * <p>
         * An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object
         * contains the name and type of the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <RecommendationRelatedAnomalyResource>.Builder} avoiding the need to create one manually via {@link List
         * <RecommendationRelatedAnomalyResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationRelatedAnomalyResource>.Builder#build()} is
         * called immediately and its result is passed to {@link #resources(List<RecommendationRelatedAnomalyResource>)}
         * .
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<RecommendationRelatedAnomalyResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<RecommendationRelatedAnomalyResource>)
         */
        Builder resources(Consumer<RecommendationRelatedAnomalyResource.Builder>... resources);

        /**
         * <p>
         * Information about where the anomalous behavior related the recommendation was found. For example, details in
         * Amazon CloudWatch metrics.
         * </p>
         * 
         * @param sourceDetails
         *        Information about where the anomalous behavior related the recommendation was found. For example,
         *        details in Amazon CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetails(Collection<RecommendationRelatedAnomalySourceDetail> sourceDetails);

        /**
         * <p>
         * Information about where the anomalous behavior related the recommendation was found. For example, details in
         * Amazon CloudWatch metrics.
         * </p>
         * 
         * @param sourceDetails
         *        Information about where the anomalous behavior related the recommendation was found. For example,
         *        details in Amazon CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetails(RecommendationRelatedAnomalySourceDetail... sourceDetails);

        /**
         * <p>
         * Information about where the anomalous behavior related the recommendation was found. For example, details in
         * Amazon CloudWatch metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <RecommendationRelatedAnomalySourceDetail>.Builder} avoiding the need to create one manually via {@link List
         * <RecommendationRelatedAnomalySourceDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationRelatedAnomalySourceDetail>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #sourceDetails(List<RecommendationRelatedAnomalySourceDetail>)}.
         * 
         * @param sourceDetails
         *        a consumer that will call methods on {@link List<RecommendationRelatedAnomalySourceDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDetails(List<RecommendationRelatedAnomalySourceDetail>)
         */
        Builder sourceDetails(Consumer<RecommendationRelatedAnomalySourceDetail.Builder>... sourceDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<RecommendationRelatedAnomalyResource> resources = DefaultSdkAutoConstructList.getInstance();

        private List<RecommendationRelatedAnomalySourceDetail> sourceDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationRelatedAnomaly model) {
            resources(model.resources);
            sourceDetails(model.sourceDetails);
        }

        public final Collection<RecommendationRelatedAnomalyResource.Builder> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources != null ? resources.stream().map(RecommendationRelatedAnomalyResource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<RecommendationRelatedAnomalyResource> resources) {
            this.resources = RecommendationRelatedAnomalyResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(RecommendationRelatedAnomalyResource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<RecommendationRelatedAnomalyResource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> RecommendationRelatedAnomalyResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<RecommendationRelatedAnomalyResource.BuilderImpl> resources) {
            this.resources = RecommendationRelatedAnomalyResourcesCopier.copyFromBuilder(resources);
        }

        public final Collection<RecommendationRelatedAnomalySourceDetail.Builder> getSourceDetails() {
            if (sourceDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceDetails != null ? sourceDetails.stream().map(RecommendationRelatedAnomalySourceDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceDetails(Collection<RecommendationRelatedAnomalySourceDetail> sourceDetails) {
            this.sourceDetails = RelatedAnomalySourceDetailsCopier.copy(sourceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDetails(RecommendationRelatedAnomalySourceDetail... sourceDetails) {
            sourceDetails(Arrays.asList(sourceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDetails(Consumer<RecommendationRelatedAnomalySourceDetail.Builder>... sourceDetails) {
            sourceDetails(Stream.of(sourceDetails)
                    .map(c -> RecommendationRelatedAnomalySourceDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSourceDetails(Collection<RecommendationRelatedAnomalySourceDetail.BuilderImpl> sourceDetails) {
            this.sourceDetails = RelatedAnomalySourceDetailsCopier.copyFromBuilder(sourceDetails);
        }

        @Override
        public RecommendationRelatedAnomaly build() {
            return new RecommendationRelatedAnomaly(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
