/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recommendation information to help you remediate detected anomalous behavior that generated an insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommendation implements SdkPojo, Serializable, ToCopyableBuilder<Recommendation.Builder, Recommendation> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Recommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Link")
            .getter(getter(Recommendation::link)).setter(setter(Builder::link))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Recommendation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(Recommendation::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<List<RecommendationRelatedEvent>> RELATED_EVENTS_FIELD = SdkField
            .<List<RecommendationRelatedEvent>> builder(MarshallingType.LIST)
            .memberName("RelatedEvents")
            .getter(getter(Recommendation::relatedEvents))
            .setter(setter(Builder::relatedEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationRelatedEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationRelatedEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RecommendationRelatedAnomaly>> RELATED_ANOMALIES_FIELD = SdkField
            .<List<RecommendationRelatedAnomaly>> builder(MarshallingType.LIST)
            .memberName("RelatedAnomalies")
            .getter(getter(Recommendation::relatedAnomalies))
            .setter(setter(Builder::relatedAnomalies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedAnomalies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationRelatedAnomaly> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationRelatedAnomaly::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LINK_FIELD,
            NAME_FIELD, REASON_FIELD, RELATED_EVENTS_FIELD, RELATED_ANOMALIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String link;

    private final String name;

    private final String reason;

    private final List<RecommendationRelatedEvent> relatedEvents;

    private final List<RecommendationRelatedAnomaly> relatedAnomalies;

    private Recommendation(BuilderImpl builder) {
        this.description = builder.description;
        this.link = builder.link;
        this.name = builder.name;
        this.reason = builder.reason;
        this.relatedEvents = builder.relatedEvents;
        this.relatedAnomalies = builder.relatedAnomalies;
    }

    /**
     * <p>
     * A description of the problem.
     * </p>
     * 
     * @return A description of the problem.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A hyperlink to information to help you address the problem.
     * </p>
     * 
     * @return A hyperlink to information to help you address the problem.
     */
    public final String link() {
        return link;
    }

    /**
     * <p>
     * The name of the recommendation.
     * </p>
     * 
     * @return The name of the recommendation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The reason DevOps Guru flagged the anomalous behavior as a problem.
     * </p>
     * 
     * @return The reason DevOps Guru flagged the anomalous behavior as a problem.
     */
    public final String reason() {
        return reason;
    }

    /**
     * Returns true if the RelatedEvents property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRelatedEvents() {
        return relatedEvents != null && !(relatedEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Events that are related to the problem. Use these events to learn more about what's happening and to help address
     * the issue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Events that are related to the problem. Use these events to learn more about what's happening and to help
     *         address the issue.
     */
    public final List<RecommendationRelatedEvent> relatedEvents() {
        return relatedEvents;
    }

    /**
     * Returns true if the RelatedAnomalies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRelatedAnomalies() {
        return relatedAnomalies != null && !(relatedAnomalies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to help
     * address the issue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedAnomalies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and
     *         to help address the issue.
     */
    public final List<RecommendationRelatedAnomaly> relatedAnomalies() {
        return relatedAnomalies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(link());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedEvents() ? relatedEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedAnomalies() ? relatedAnomalies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(link(), other.link())
                && Objects.equals(name(), other.name()) && Objects.equals(reason(), other.reason())
                && hasRelatedEvents() == other.hasRelatedEvents() && Objects.equals(relatedEvents(), other.relatedEvents())
                && hasRelatedAnomalies() == other.hasRelatedAnomalies()
                && Objects.equals(relatedAnomalies(), other.relatedAnomalies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommendation").add("Description", description()).add("Link", link()).add("Name", name())
                .add("Reason", reason()).add("RelatedEvents", hasRelatedEvents() ? relatedEvents() : null)
                .add("RelatedAnomalies", hasRelatedAnomalies() ? relatedAnomalies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Link":
            return Optional.ofNullable(clazz.cast(link()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "RelatedEvents":
            return Optional.ofNullable(clazz.cast(relatedEvents()));
        case "RelatedAnomalies":
            return Optional.ofNullable(clazz.cast(relatedAnomalies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommendation> {
        /**
         * <p>
         * A description of the problem.
         * </p>
         * 
         * @param description
         *        A description of the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A hyperlink to information to help you address the problem.
         * </p>
         * 
         * @param link
         *        A hyperlink to information to help you address the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder link(String link);

        /**
         * <p>
         * The name of the recommendation.
         * </p>
         * 
         * @param name
         *        The name of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The reason DevOps Guru flagged the anomalous behavior as a problem.
         * </p>
         * 
         * @param reason
         *        The reason DevOps Guru flagged the anomalous behavior as a problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * Events that are related to the problem. Use these events to learn more about what's happening and to help
         * address the issue.
         * </p>
         * 
         * @param relatedEvents
         *        Events that are related to the problem. Use these events to learn more about what's happening and to
         *        help address the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEvents(Collection<RecommendationRelatedEvent> relatedEvents);

        /**
         * <p>
         * Events that are related to the problem. Use these events to learn more about what's happening and to help
         * address the issue.
         * </p>
         * 
         * @param relatedEvents
         *        Events that are related to the problem. Use these events to learn more about what's happening and to
         *        help address the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEvents(RecommendationRelatedEvent... relatedEvents);

        /**
         * <p>
         * Events that are related to the problem. Use these events to learn more about what's happening and to help
         * address the issue.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendationRelatedEvent>.Builder}
         * avoiding the need to create one manually via {@link List<RecommendationRelatedEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationRelatedEvent>.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedEvents(List<RecommendationRelatedEvent>)}.
         * 
         * @param relatedEvents
         *        a consumer that will call methods on {@link List<RecommendationRelatedEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedEvents(List<RecommendationRelatedEvent>)
         */
        Builder relatedEvents(Consumer<RecommendationRelatedEvent.Builder>... relatedEvents);

        /**
         * <p>
         * Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to
         * help address the issue.
         * </p>
         * 
         * @param relatedAnomalies
         *        Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening
         *        and to help address the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedAnomalies(Collection<RecommendationRelatedAnomaly> relatedAnomalies);

        /**
         * <p>
         * Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to
         * help address the issue.
         * </p>
         * 
         * @param relatedAnomalies
         *        Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening
         *        and to help address the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedAnomalies(RecommendationRelatedAnomaly... relatedAnomalies);

        /**
         * <p>
         * Anomalies that are related to the problem. Use these Anomalies to learn more about what's happening and to
         * help address the issue.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendationRelatedAnomaly>.Builder}
         * avoiding the need to create one manually via {@link List<RecommendationRelatedAnomaly>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationRelatedAnomaly>.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedAnomalies(List<RecommendationRelatedAnomaly>)}.
         * 
         * @param relatedAnomalies
         *        a consumer that will call methods on {@link List<RecommendationRelatedAnomaly>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedAnomalies(List<RecommendationRelatedAnomaly>)
         */
        Builder relatedAnomalies(Consumer<RecommendationRelatedAnomaly.Builder>... relatedAnomalies);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String link;

        private String name;

        private String reason;

        private List<RecommendationRelatedEvent> relatedEvents = DefaultSdkAutoConstructList.getInstance();

        private List<RecommendationRelatedAnomaly> relatedAnomalies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            description(model.description);
            link(model.link);
            name(model.name);
            reason(model.reason);
            relatedEvents(model.relatedEvents);
            relatedAnomalies(model.relatedAnomalies);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLink() {
            return link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<RecommendationRelatedEvent.Builder> getRelatedEvents() {
            if (relatedEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedEvents != null ? relatedEvents.stream().map(RecommendationRelatedEvent::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedEvents(Collection<RecommendationRelatedEvent> relatedEvents) {
            this.relatedEvents = RecommendationRelatedEventsCopier.copy(relatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(RecommendationRelatedEvent... relatedEvents) {
            relatedEvents(Arrays.asList(relatedEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(Consumer<RecommendationRelatedEvent.Builder>... relatedEvents) {
            relatedEvents(Stream.of(relatedEvents).map(c -> RecommendationRelatedEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedEvents(Collection<RecommendationRelatedEvent.BuilderImpl> relatedEvents) {
            this.relatedEvents = RecommendationRelatedEventsCopier.copyFromBuilder(relatedEvents);
        }

        public final Collection<RecommendationRelatedAnomaly.Builder> getRelatedAnomalies() {
            if (relatedAnomalies instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedAnomalies != null ? relatedAnomalies.stream().map(RecommendationRelatedAnomaly::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedAnomalies(Collection<RecommendationRelatedAnomaly> relatedAnomalies) {
            this.relatedAnomalies = RecommendationRelatedAnomaliesCopier.copy(relatedAnomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedAnomalies(RecommendationRelatedAnomaly... relatedAnomalies) {
            relatedAnomalies(Arrays.asList(relatedAnomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedAnomalies(Consumer<RecommendationRelatedAnomaly.Builder>... relatedAnomalies) {
            relatedAnomalies(Stream.of(relatedAnomalies)
                    .map(c -> RecommendationRelatedAnomaly.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedAnomalies(Collection<RecommendationRelatedAnomaly.BuilderImpl> relatedAnomalies) {
            this.relatedAnomalies = RecommendationRelatedAnomaliesCopier.copyFromBuilder(relatedAnomalies);
        }

        @Override
        public Recommendation build() {
            return new Recommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
