/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInsightResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeInsightResponse.Builder, DescribeInsightResponse> {
    private static final SdkField<ProactiveInsight> PROACTIVE_INSIGHT_FIELD = SdkField
            .<ProactiveInsight> builder(MarshallingType.SDK_POJO).memberName("ProactiveInsight")
            .getter(getter(DescribeInsightResponse::proactiveInsight)).setter(setter(Builder::proactiveInsight))
            .constructor(ProactiveInsight::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsight").build()).build();

    private static final SdkField<ReactiveInsight> REACTIVE_INSIGHT_FIELD = SdkField
            .<ReactiveInsight> builder(MarshallingType.SDK_POJO).memberName("ReactiveInsight")
            .getter(getter(DescribeInsightResponse::reactiveInsight)).setter(setter(Builder::reactiveInsight))
            .constructor(ReactiveInsight::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_INSIGHT_FIELD,
            REACTIVE_INSIGHT_FIELD));

    private final ProactiveInsight proactiveInsight;

    private final ReactiveInsight reactiveInsight;

    private DescribeInsightResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveInsight = builder.proactiveInsight;
        this.reactiveInsight = builder.reactiveInsight;
    }

    /**
     * <p>
     * An <code>ProactiveInsight</code> object that represents the requested insight.
     * </p>
     * 
     * @return An <code>ProactiveInsight</code> object that represents the requested insight.
     */
    public final ProactiveInsight proactiveInsight() {
        return proactiveInsight;
    }

    /**
     * <p>
     * An <code>ReactiveInsight</code> object that represents the requested insight.
     * </p>
     * 
     * @return An <code>ReactiveInsight</code> object that represents the requested insight.
     */
    public final ReactiveInsight reactiveInsight() {
        return reactiveInsight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proactiveInsight());
        hashCode = 31 * hashCode + Objects.hashCode(reactiveInsight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInsightResponse)) {
            return false;
        }
        DescribeInsightResponse other = (DescribeInsightResponse) obj;
        return Objects.equals(proactiveInsight(), other.proactiveInsight())
                && Objects.equals(reactiveInsight(), other.reactiveInsight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInsightResponse").add("ProactiveInsight", proactiveInsight())
                .add("ReactiveInsight", reactiveInsight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProactiveInsight":
            return Optional.ofNullable(clazz.cast(proactiveInsight()));
        case "ReactiveInsight":
            return Optional.ofNullable(clazz.cast(reactiveInsight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInsightResponse, T> g) {
        return obj -> g.apply((DescribeInsightResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInsightResponse> {
        /**
         * <p>
         * An <code>ProactiveInsight</code> object that represents the requested insight.
         * </p>
         * 
         * @param proactiveInsight
         *        An <code>ProactiveInsight</code> object that represents the requested insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsight(ProactiveInsight proactiveInsight);

        /**
         * <p>
         * An <code>ProactiveInsight</code> object that represents the requested insight.
         * </p>
         * This is a convenience that creates an instance of the {@link ProactiveInsight.Builder} avoiding the need to
         * create one manually via {@link ProactiveInsight#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProactiveInsight.Builder#build()} is called immediately and its
         * result is passed to {@link #proactiveInsight(ProactiveInsight)}.
         * 
         * @param proactiveInsight
         *        a consumer that will call methods on {@link ProactiveInsight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveInsight(ProactiveInsight)
         */
        default Builder proactiveInsight(Consumer<ProactiveInsight.Builder> proactiveInsight) {
            return proactiveInsight(ProactiveInsight.builder().applyMutation(proactiveInsight).build());
        }

        /**
         * <p>
         * An <code>ReactiveInsight</code> object that represents the requested insight.
         * </p>
         * 
         * @param reactiveInsight
         *        An <code>ReactiveInsight</code> object that represents the requested insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsight(ReactiveInsight reactiveInsight);

        /**
         * <p>
         * An <code>ReactiveInsight</code> object that represents the requested insight.
         * </p>
         * This is a convenience that creates an instance of the {@link ReactiveInsight.Builder} avoiding the need to
         * create one manually via {@link ReactiveInsight#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReactiveInsight.Builder#build()} is called immediately and its
         * result is passed to {@link #reactiveInsight(ReactiveInsight)}.
         * 
         * @param reactiveInsight
         *        a consumer that will call methods on {@link ReactiveInsight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reactiveInsight(ReactiveInsight)
         */
        default Builder reactiveInsight(Consumer<ReactiveInsight.Builder> reactiveInsight) {
            return reactiveInsight(ReactiveInsight.builder().applyMutation(reactiveInsight).build());
        }
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private ProactiveInsight proactiveInsight;

        private ReactiveInsight reactiveInsight;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInsightResponse model) {
            super(model);
            proactiveInsight(model.proactiveInsight);
            reactiveInsight(model.reactiveInsight);
        }

        public final ProactiveInsight.Builder getProactiveInsight() {
            return proactiveInsight != null ? proactiveInsight.toBuilder() : null;
        }

        @Override
        public final Builder proactiveInsight(ProactiveInsight proactiveInsight) {
            this.proactiveInsight = proactiveInsight;
            return this;
        }

        public final void setProactiveInsight(ProactiveInsight.BuilderImpl proactiveInsight) {
            this.proactiveInsight = proactiveInsight != null ? proactiveInsight.build() : null;
        }

        public final ReactiveInsight.Builder getReactiveInsight() {
            return reactiveInsight != null ? reactiveInsight.toBuilder() : null;
        }

        @Override
        public final Builder reactiveInsight(ReactiveInsight reactiveInsight) {
            this.reactiveInsight = reactiveInsight;
            return this;
        }

        public final void setReactiveInsight(ReactiveInsight.BuilderImpl reactiveInsight) {
            this.reactiveInsight = reactiveInsight != null ? reactiveInsight.build() : null;
        }

        @Override
        public DescribeInsightResponse build() {
            return new DescribeInsightResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
