/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.CostEstimationServiceResourceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceResourceCost
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceResourceCost> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ServiceResourceCost.getter(ServiceResourceCost::type)).setter(ServiceResourceCost.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ServiceResourceCost.getter(ServiceResourceCost::stateAsString)).setter(ServiceResourceCost.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(ServiceResourceCost.getter(ServiceResourceCost::count)).setter(ServiceResourceCost.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<Double> UNIT_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UnitCost").getter(ServiceResourceCost.getter(ServiceResourceCost::unitCost)).setter(ServiceResourceCost.setter(Builder::unitCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitCost").build()}).build();
    private static final SdkField<Double> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Cost").getter(ServiceResourceCost.getter(ServiceResourceCost::cost)).setter(ServiceResourceCost.setter(Builder::cost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATE_FIELD, COUNT_FIELD, UNIT_COST_FIELD, COST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String state;
    private final Integer count;
    private final Double unitCost;
    private final Double cost;

    private ServiceResourceCost(BuilderImpl builder) {
        this.type = builder.type;
        this.state = builder.state;
        this.count = builder.count;
        this.unitCost = builder.unitCost;
        this.cost = builder.cost;
    }

    public final String type() {
        return this.type;
    }

    public final CostEstimationServiceResourceState state() {
        return CostEstimationServiceResourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer count() {
        return this.count;
    }

    public final Double unitCost() {
        return this.unitCost;
    }

    public final Double cost() {
        return this.cost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceResourceCost)) {
            return false;
        }
        ServiceResourceCost other = (ServiceResourceCost)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.unitCost(), other.unitCost()) && Objects.equals(this.cost(), other.cost());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceResourceCost").add("Type", (Object)this.type()).add("State", (Object)this.stateAsString()).add("Count", (Object)this.count()).add("UnitCost", (Object)this.unitCost()).add("Cost", (Object)this.cost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "UnitCost": {
                return Optional.ofNullable(clazz.cast(this.unitCost()));
            }
            case "Cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceResourceCost, T> g) {
        return obj -> g.apply((ServiceResourceCost)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String state;
        private Integer count;
        private Double unitCost;
        private Double cost;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceResourceCost model) {
            this.type(model.type);
            this.state(model.state);
            this.count(model.count);
            this.unitCost(model.unitCost);
            this.cost(model.cost);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CostEstimationServiceResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Double getUnitCost() {
            return this.unitCost;
        }

        @Override
        public final Builder unitCost(Double unitCost) {
            this.unitCost = unitCost;
            return this;
        }

        public final void setUnitCost(Double unitCost) {
            this.unitCost = unitCost;
        }

        public final Double getCost() {
            return this.cost;
        }

        @Override
        public final Builder cost(Double cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(Double cost) {
            this.cost = cost;
        }

        public ServiceResourceCost build() {
            return new ServiceResourceCost(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceResourceCost> {
        public Builder type(String var1);

        public Builder state(String var1);

        public Builder state(CostEstimationServiceResourceState var1);

        public Builder count(Integer var1);

        public Builder unitCost(Double var1);

        public Builder cost(Double var1);
    }
}

