/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.ChannelsCopier;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.NotificationChannel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationChannelsResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, ListNotificationChannelsResponse> {
    private static final SdkField<List<NotificationChannel>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(ListNotificationChannelsResponse.getter(ListNotificationChannelsResponse::channels)).setter(ListNotificationChannelsResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNotificationChannelsResponse.getter(ListNotificationChannelsResponse::nextToken)).setter(ListNotificationChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, NEXT_TOKEN_FIELD));
    private final List<NotificationChannel> channels;
    private final String nextToken;

    private ListNotificationChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.nextToken = builder.nextToken;
    }

    public boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public List<NotificationChannel> channels() {
        return this.channels;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationChannelsResponse)) {
            return false;
        }
        ListNotificationChannelsResponse other = (ListNotificationChannelsResponse)((Object)obj);
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNotificationChannelsResponse").add("Channels", this.hasChannels() ? this.channels() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationChannelsResponse, T> g) {
        return obj -> g.apply((ListNotificationChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private List<NotificationChannel> channels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationChannelsResponse model) {
            super(model);
            this.channels(model.channels);
            this.nextToken(model.nextToken);
        }

        public final Collection<NotificationChannel.Builder> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels != null ? (Collection)this.channels.stream().map(NotificationChannel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channels(Collection<NotificationChannel> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(NotificationChannel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<NotificationChannel.Builder> ... channels) {
            this.channels(Stream.of(channels).map(c -> (NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChannels(Collection<NotificationChannel.BuilderImpl> channels) {
            this.channels = ChannelsCopier.copyFromBuilder(channels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNotificationChannelsResponse build() {
            return new ListNotificationChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationChannelsResponse> {
        public Builder channels(Collection<NotificationChannel> var1);

        public Builder channels(NotificationChannel ... var1);

        public Builder channels(Consumer<NotificationChannel.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

