/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.EventClass;
import software.amazon.awssdk.services.devopsguru.model.EventDataSource;
import software.amazon.awssdk.services.devopsguru.model.EventResource;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.services.devopsguru.model.___listOfEventResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(Event.getter(Event::dataSourceAsString)).setter(Event.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventClass").getter(Event.getter(Event::eventClassAsString)).setter(Event.setter(Builder::eventClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventClass").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(Event.getter(Event::eventSource)).setter(Event.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Event.getter(Event::id)).setter(Event.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Event.getter(Event::name)).setter(Event.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(Event.getter(Event::resourceCollection)).setter(Event.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<List<EventResource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(Event.getter(Event::resources)).setter(Event.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Time").getter(Event.getter(Event::time)).setter(Event.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, EVENT_CLASS_FIELD, EVENT_SOURCE_FIELD, ID_FIELD, NAME_FIELD, RESOURCE_COLLECTION_FIELD, RESOURCES_FIELD, TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSource;
    private final String eventClass;
    private final String eventSource;
    private final String id;
    private final String name;
    private final ResourceCollection resourceCollection;
    private final List<EventResource> resources;
    private final Instant time;

    private Event(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.eventClass = builder.eventClass;
        this.eventSource = builder.eventSource;
        this.id = builder.id;
        this.name = builder.name;
        this.resourceCollection = builder.resourceCollection;
        this.resources = builder.resources;
        this.time = builder.time;
    }

    public EventDataSource dataSource() {
        return EventDataSource.fromValue(this.dataSource);
    }

    public String dataSourceAsString() {
        return this.dataSource;
    }

    public EventClass eventClass() {
        return EventClass.fromValue(this.eventClass);
    }

    public String eventClassAsString() {
        return this.eventClass;
    }

    public String eventSource() {
        return this.eventSource;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public List<EventResource> resources() {
        return this.resources;
    }

    public Instant time() {
        return this.time;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(this.eventClassAsString(), other.eventClassAsString()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.time(), other.time());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("DataSource", (Object)this.dataSourceAsString()).add("EventClass", (Object)this.eventClassAsString()).add("EventSource", (Object)this.eventSource()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ResourceCollection", (Object)this.resourceCollection()).add("Resources", this.hasResources() ? this.resources() : null).add("Time", (Object)this.time()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "EventClass": {
                return Optional.ofNullable(clazz.cast(this.eventClassAsString()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSource;
        private String eventClass;
        private String eventSource;
        private String id;
        private String name;
        private ResourceCollection resourceCollection;
        private List<EventResource> resources = DefaultSdkAutoConstructList.getInstance();
        private Instant time;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.dataSource(model.dataSource);
            this.eventClass(model.eventClass);
            this.eventSource(model.eventSource);
            this.id(model.id);
            this.name(model.name);
            this.resourceCollection(model.resourceCollection);
            this.resources(model.resources);
            this.time(model.time);
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(EventDataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getEventClass() {
            return this.eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(EventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public final Collection<EventResource.Builder> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources != null ? (Collection)this.resources.stream().map(EventResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<EventResource> resources) {
            this.resources = ___listOfEventResourceCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(EventResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<EventResource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (EventResource)((EventResource.Builder)EventResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<EventResource.BuilderImpl> resources) {
            this.resources = ___listOfEventResourceCopier.copyFromBuilder(resources);
        }

        public final Instant getTime() {
            return this.time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder dataSource(String var1);

        public Builder dataSource(EventDataSource var1);

        public Builder eventClass(String var1);

        public Builder eventClass(EventClass var1);

        public Builder eventSource(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder resources(Collection<EventResource> var1);

        public Builder resources(EventResource ... var1);

        public Builder resources(Consumer<EventResource.Builder> ... var1);

        public Builder time(Instant var1);
    }
}

